package io.geekidea.springbootplus.test;

import cn.hutool.crypto.digest.MD5;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.wecloud.im.tillo.app_ws.model.request.ReceiveModel;

import java.util.Date;

/**
 * 客户方签名字符串生成 单元测试
 */
public class SignTest {


    /**
     * 获取sign,客户端sdk得到sign之后就可以进行登录,websocket连接初始化需要带上sign,验证通过才能连接成功
     * <p>
     * sign = MD5{timestamp + clientId + appKey + appSecret}
     *
     * @param appKey
     * @param appSecret
     */
    private static void getSign(String timestamp, String clientId, String appKey, String appSecret) {

        String sign = new MD5().digestHex(timestamp + clientId + appKey + appSecret);

        System.out.println("timestamp:" + timestamp);
        System.out.println("sign:" + sign);

    }

    public static void main(String[] args) {
        String clientId = "client_333";
        String appKey = "elLwpel1gWCHDqZy";
        String appSecret = "68809bb5a9077a83631aeb0b17b5965d6b2302faf2ab3737";
        String timestamp = String.valueOf(new Date().getTime());
        getSign(timestamp, clientId, appKey, appSecret);
    }

    private static void jsonTest() throws JsonProcessingException {
        String data = "{\n" +
                "\"reqId\":\"123123\",\n" +
                "\"cmd\":1,\n" +
                "\"data\":{\n" +
                "    \"type\":-1,\n" +
                "    \"text\":\"这是一个纯文本消息\",\n" +
                "    \"attrs\":{\n" +
                "    \"a\":\"attrs是用来存储用户自定义的一些键值对\"}}\n" +
                "}\n";

        // json转换成对象
        JsonMapper jsonMapper = new JsonMapper();
        ReceiveModel receiveModel = jsonMapper.readValue(data, ReceiveModel.class);

        // data对象转换成json
        ObjectMapper objectMapper = new ObjectMapper();
        String s = objectMapper.writeValueAsString(receiveModel.getData());
    }


}
