package com.wecloud.im.controller;

import com.wecloud.im.param.ImClientBlacklistPageParam;
import com.wecloud.im.param.ImClientBlacklistQueryVo;
import com.wecloud.im.param.add.ImClientBlacklistUpdate;
import com.wecloud.im.service.ImClientBlacklistService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 黑名单 控制器
 *
 * @author wei
 * @since 2021-06-17
 */
@Slf4j
@RestController
@RequestMapping("/ClientBlacklist")
@Api(value = "黑名单API", tags = {"黑名单"})
public class ImClientBlacklistController extends BaseController {

    @Autowired
    private ImClientBlacklistService imClientBlacklistService;

    /**
     * 添加黑名单
     */
    @PostMapping("/add")
    @ApiOperation(value = "拉入黑名单")
    public ApiResult<Boolean> addImClientBlacklist(@Validated(Add.class) @RequestBody ImClientBlacklistUpdate imClientBlacklistUpdate) throws Exception {
        return imClientBlacklistService.addImClientBlacklist(imClientBlacklistUpdate);
    }


    /**
     * 删除黑名单
     */
    @PostMapping("/delete")
    @ApiOperation(value = "移出黑名单")
    public ApiResult<Boolean> deleteImClientBlacklist(@RequestBody ImClientBlacklistUpdate imClientBlacklistUpdate) throws Exception {
        return imClientBlacklistService.removeImClientBlacklist(imClientBlacklistUpdate);
    }

    /**
     * 黑名单分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "黑名单分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "黑名单分页列表")
    public ApiResult<Paging<ImClientBlacklistQueryVo>> getImClientBlacklistPageList(@RequestBody ImClientBlacklistPageParam imClientBlacklistPageParam) throws Exception {
        return imClientBlacklistService.getImClientBlacklistPageList(imClientBlacklistPageParam);
    }

//    /**
//     * 修改黑名单
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改黑名单", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改黑名单")
//    public ApiResult<Boolean> updateImClientBlacklist(@Validated(Update.class) @RequestBody ImClientBlacklist imClientBlacklist) throws Exception {
//        boolean flag = imClientBlacklistService.updateImClientBlacklist(imClientBlacklist);
//        return ApiResult.result(flag);
//    }
//    /**
//     * 获取黑名单详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "黑名单详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "黑名单详情")
//    public ApiResult<ImClientBlacklistQueryVo> getImClientBlacklist(@PathVariable("id") Long id) throws Exception {
//        ImClientBlacklistQueryVo imClientBlacklistQueryVo = imClientBlacklistService.getImClientBlacklistById(id);
//        return ApiResult.ok(imClientBlacklistQueryVo);
//    }

//    /**
//     * 黑名单分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "黑名单分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "黑名单分页列表")
//    public ApiResult<Paging<ImClientBlacklistQueryVo>> getImClientBlacklistPageList(@Validated @RequestBody ImClientBlacklistPageParam imClientBlacklistPageParam) throws Exception {
//        Paging<ImClientBlacklistQueryVo> paging = imClientBlacklistService.getImClientBlacklistPageList(imClientBlacklistPageParam);
//        return ApiResult.ok(paging);
//    }

}

