package com.wecloud.im.ws.cache;

import com.wecloud.im.ws.model.redis.ClientChannelInfo;
import com.wecloud.im.ws.model.redis.ClientConnectionInfo;

import java.util.List;

/**
 * @author hewei123@163.com
 * @Description 用户与redis绑定
 * @createTime 2020年04月14日 16:21:00
 */
public interface UserCacheService {

    /**
     * 用户上线绑定机器ip
     *
     * @param longChannelId
     */
    public void online(String appKey, String clientId, String longChannelId);

    /**
     * 用户下线删除绑定机器ip
     *
     * @param longChannelId
     */
    public void offline(String appKey, String clientId, String longChannelId);

    /**
     * 根据ClientId从redis获取client信息
     *
     * @param appKey
     * @param clientId
     * @return
     */
    List<ClientChannelInfo> getIpByClientIdAndOnline(String appKey, String clientId);

}
