package com.wecloud.im.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * 发送群聊消息入参
 * @Author luozh
 * @Date 2022年04月29日 16:00
 * @Version 1.0
 */
@Data
public class GroupChatMessageParam {


    @NotEmpty(message = "发送人id不能为空")
    @ApiModelProperty("发送人id")
    private String fromUserId;

    @NotEmpty(message = "接收群id不能为空")
    @ApiModelProperty("接收群id")
    private String toGroupIds;

    @ApiModelProperty("指定一个或多个用户")
    private String toUserIds;

    @NotEmpty(message = "消息类型不能为空")
    @ApiModelProperty("消息类型")
    private String messageType;

    @NotEmpty(message = "消息不能为空")
    @ApiModelProperty("消息")
    private String content;

    @ApiModelProperty("指定离线推送通知中的推送内容")
    private String pushContent;

    @ApiModelProperty("是否包含发送用户")
    private Boolean includeSender;

    @ApiModelProperty("是否为@消息")
    private Boolean mentioned;

    @ApiModelProperty("是否为静默消息")
    private Boolean silent;

    @ApiModelProperty("推送配置")
    private PushExtParam pushExt;


}
