package com.wecloud.im.ws;

import lombok.Data;

import java.io.Serializable;

/**
 * IM相关常量
 */
@Data
public class ImConstant implements Serializable {

    /**
     * channel超时n次后断开连接
     */
    public static final int READ_IDLE_CLOSE_COUNT = 5;


    /**
     * channel 读取时间 心跳检查间隔实际 (秒)
     */
    public static final int READER_IDLE_TIME = 5;

    /**
     * 心跳
     */
    public static final String PING = "ping";
    /**
     * 心跳
     */
    public static final String PONG = "pong";


    /**
     * 推送
     */
    public static final String PUSH_KEY = "push";
    public static final String TITLE = "title";
    public static final String SUB_TITLE = "subTitle";

    /**
     * 数据
     */
    public static final String DATA = "data";

    /**
     * 您收到一条新消息
     */
    public static final String PUSH_TITLE = "您收到一条新消息";

    /**
     * 点击查看
     */
    public static final String PUSH_BODY = "点击查看";

    /**
     * 会话id的key名
     */
    public static final String TO_CONVERSATION_KEY = "toConversation";


    /**
     * 消息类型
     */
    public static final String MSG_TYPE = "type";

    public static final String CMD = "cmd";

}
