package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.McPlain;
import com.jumeirah.common.mapper.McPlainMapper;
import com.jumeirah.common.param.McPlainPageParam;
import com.jumeirah.common.service.McPlainService;
import com.jumeirah.common.vo.McPlainQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 商家飞机表 服务实现类
 *
 * @author xxx
 * @since 2020-10-19
 */
@Slf4j
@Service
public class McPlainServiceImpl extends BaseServiceImpl<McPlainMapper, McPlain> implements McPlainService {

    @Autowired
    private McPlainMapper mcPlainMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveMcPlain(McPlain mcPlain) throws Exception {
        return super.save(mcPlain);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateMcPlain(McPlain mcPlain) throws Exception {
        return super.updateById(mcPlain);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteMcPlain(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public McPlainQueryVo getMcPlainById(Long id) throws Exception {
        return mcPlainMapper.getMcPlainById(id);
    }

    @Override
    public Paging<McPlainQueryVo> getMcPlainPageList(McPlainPageParam mcPlainPageParam) throws Exception {
        Page<McPlainQueryVo> page = new PageInfo<>(mcPlainPageParam, OrderItem.desc(getLambdaColumn(McPlain::getCreateTime)));
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        IPage<McPlainQueryVo> iPage = mcPlainMapper.getMcPlainPageList(page, mcPlainPageParam,jwtToken.getMcId());
        return new Paging<McPlainQueryVo>(iPage);
    }

}
