package com.wecloud.im.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.param.ImClientPageParam;
import com.wecloud.im.param.ImClientQueryVo;
import com.wecloud.im.param.ImClientSimpleDto;
import com.wecloud.im.vo.GetInfoListVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.List;

/**
 * 终端表 Mapper 接口
 *
 * @author wei
 * @since 2021-04-27
 */
@Repository
public interface ImClientMapper extends BaseMapper<ImClient> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImClient getImClientById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param imClientPageParam
     * @return
     */
    IPage<ImClientQueryVo> getImClientPageList(@Param("page") Page page, @Param("param") ImClientPageParam imClientPageParam);


    int removeOldToken(@Param("appId") Long appId, @Param("deviceToken") String deviceToken);


    List<GetInfoListVo> getInfoList(@Param("appId") Long appId, @Param("conversationId") Long conversationId, @Param("clientIds") List<String> clientIds);

    List<ImClientSimpleDto> getSimpleClients(@Param("appId")Long appId, @Param("clientIds")List<String> clientIds);
}
