package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author Future
 * @Date 2022/5/22 23:40
 * @Description 单人音视频记录表
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "单人音视频记录")
public class ImRtcRecord extends BaseEntity {

    private static final long serialVersionUID = -523597842194055670L;

    @NotNull(message = "主键id不能为空")
    @ApiModelProperty("主键id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("频道id")
    private Long channelId;

    @ApiModelProperty("发起方clientId")
    private String fromClientId;

    @ApiModelProperty("接收方clientId")
    private String toClientId;

    @ApiModelProperty(value = "音视频类型: 1-video或2-voice")
    private Integer callType;

    /**
     * 单人音视频状态枚举
     * @see com.wecloud.im.sdk.enums.RtcStateEnum
     */
    @ApiModelProperty("频道状态，1：音视频发起，2：音视频中，3：音视频结束")
    private Integer state;

    @ApiModelProperty("音视频开始时间")
    private Date startTime;

    @ApiModelProperty("音视频结束时间")
    private Date endTime;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

}
