package com.jumeirah.common.service.impl;

import com.jumeirah.common.entity.Feedback;
import com.jumeirah.common.mapper.FeedbackMapper;
import com.jumeirah.common.service.FeedbackService;
    import com.jumeirah.common.param.FeedbackPageParam;
    import com.jumeirah.common.param.FeedbackQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
    import io.geekidea.springbootplus.framework.core.pagination.Paging;
    import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
    import com.baomidou.mybatisplus.core.metadata.IPage;
    import com.baomidou.mybatisplus.core.metadata.OrderItem;
    import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
    import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 意见反馈 服务实现类
 *
 * @author giao
 * @since 2020-10-26
 */
@Slf4j
@Service
public class FeedbackServiceImpl extends BaseServiceImpl<FeedbackMapper, Feedback> implements FeedbackService {

@Autowired
private FeedbackMapper feedbackMapper;

@Transactional(rollbackFor = Exception.class)
@Override
public boolean saveFeedback(Feedback feedback)throws Exception{
        return super.save(feedback);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean updateFeedback(Feedback feedback)throws Exception{
        return super.updateById(feedback);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean deleteFeedback(Long id)throws Exception{
        return super.removeById(id);
        }

    @Override
    public FeedbackQueryVo getFeedbackById(Long id)throws Exception{
            return feedbackMapper.getFeedbackById(id);
            }

@Override
public Paging<FeedbackQueryVo> getFeedbackPageList(FeedbackPageParam feedbackPageParam)throws Exception{
        Page<FeedbackQueryVo> page=new PageInfo<>(feedbackPageParam,OrderItem.desc(getLambdaColumn(Feedback::getCreateTime)));
            IPage<FeedbackQueryVo> iPage= feedbackMapper.getFeedbackPageList(page, feedbackPageParam);
        return new Paging<FeedbackQueryVo>(iPage);
        }

        }
