package com.wecloud.im.controller;

import com.alibaba.fastjson.JSON;
import com.wecloud.im.param.InviteToMultiMeetParam;
import com.wecloud.im.param.RejectToMultiMeetParam;
import com.wecloud.im.param.rtc.RejectRtcChannelParam;
import com.wecloud.multimeet.service.MultiMeetService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author wenzhida
 * @Date 2022/3/7 18:08
 * @Description 多人音视频通话控制器
 */
@Slf4j
@RestController
@RequestMapping("/multiMeet")
@Api(value = "多人音视频通话", tags = {"多人音视频通话"})
public class ImMultiMeetController extends BaseController {

    @Autowired
    private MultiMeetService multiMeetService;

    /**
     * 并邀请客户端加入
     */
    @PostMapping("/invite")
    @ApiOperation(value = "邀请加入多人音视频会议", notes = "邀请加入多人音视频会议")
    public ApiResult<Boolean> invite(@RequestBody InviteToMultiMeetParam param) {
        log.info("邀请加入多人音视频会议入参 {}", JSON.toJSONString(param));
        if (CollectionUtils.isEmpty(param.getToClients())) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        multiMeetService.invite(param);
        return ApiResult.ok();
    }


    @PostMapping("/reject")
    @ApiOperation(value = "拒接进入会议", notes = "拒接进入会议")
    public ApiResult<Boolean> reject(@RequestBody RejectToMultiMeetParam param) {
        log.info("拒绝加入多人音视频会议入参 {}", JSON.toJSONString(param));
        multiMeetService.reject(param);
        return ApiResult.ok();
    }


}

