package com.wecloud.im.externalaccess.service;

import io.geekidea.springbootplus.framework.common.exception.BusinessException;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.externalaccess.entity.User;
import com.wecloud.im.externalaccess.mapper.UserMapper;
import com.wecloud.im.externalaccess.param.FriendDto;
import com.wecloud.im.friend.param.ImFriendApplyDto;
import com.wecloud.im.friend.param.ImFriendBaseDto;
import com.wecloud.im.friend.param.ImFriendBaseParam;
import com.wecloud.im.friend.param.ImFriendPageParam;
import com.wecloud.im.friend.service.ImFriendService;
import com.wecloud.im.service.ImClientService;

/**
 * @Author wenzhida
 * @Date 2022/2/21 17:05
 * @Description 用户服务接口
 */
@Service
public class FriendService extends BaseServiceImpl<UserMapper, User> {

    @Autowired
    private ImClientService imClientService;

    @Autowired
    private ImFriendService imFriendService;

    @Autowired
    private UserService userService;


    public FriendDto getFriendInfo(ImClient currentClient, ImFriendBaseParam param) {
        if (currentClient == null) {
            throw new BusinessException("当前登录用户未找到");
        }
        ImClient friendClient = imClientService.getCacheImClient(currentClient.getFkAppid(), param.getFriendClientId());
        if (friendClient == null) {
            throw new BusinessException("朋友信息未找到");
        }
        ImFriendApplyDto friendInfo = imFriendService.getFriendInfo(currentClient.getClientId(), friendClient.getClientId());
        if (friendInfo == null) {
            throw new BusinessException("朋友信息未找到");
        }
        User user = userService.getOne(
                new QueryWrapper<User>().lambda()
                        .in(User::getId, friendInfo.getFriendClientId())
        );
        FriendDto friendDto = new FriendDto();
        BeanUtils.copyProperties(friendInfo, friendDto);
        if (user != null) {
            friendDto.setIdNumber(user.getIdNumber());
            friendDto.setHeadPortrait(user.getHeadPortrait());
            friendDto.setNickname(user.getNickname());
        }
        return friendDto;
    }

    /**
     * 全量获取好友列表
     */
    public List<FriendDto> getFriends(ImClient currentClient) {
        if (currentClient == null) {
            throw new BusinessException("当前登录用户未找到");
        }
        ImFriendPageParam pageParam = new ImFriendPageParam();
        pageParam.setPageIndex(1L);
        pageParam.setPageSize(Long.MAX_VALUE);
        Paging<ImFriendBaseDto> pageFriends = imFriendService.getImFriendPageList(currentClient.getClientId(), pageParam);
        List<FriendDto> friendDtoList = Lists.newArrayList();
        if (pageFriends == null || CollectionUtils.isEmpty(pageFriends.getRecords())) {
            return friendDtoList;
        }
        List<String> friendClientIds = pageFriends.getRecords().stream().map(ImFriendBaseDto::getFriendClientId).collect(Collectors.toList());
        List<User> userList = userService.list(
                new QueryWrapper<User>().lambda()
                        .in(User::getId, friendClientIds)
        );
        if (CollectionUtils.isEmpty(userList)) {
            return friendDtoList;
        }
        Map<String, User> userMap = Maps.newHashMap();
        for (User user : userList) {
            userMap.put(user.getId().toString(), user);
        }
        for (ImFriendBaseDto record : pageFriends.getRecords()) {
            FriendDto friendDto = new FriendDto();
            BeanUtils.copyProperties(record, friendDto);
            User user = userMap.get(record.getFriendClientId());
            if (user != null) {
                friendDto.setIdNumber(user.getIdNumber());
                friendDto.setHeadPortrait(user.getHeadPortrait());
                friendDto.setNickname(user.getNickname());
            }
            friendDtoList.add(friendDto);
        }
        return friendDtoList;
    }

    /**
     * 获取好友列表申请
     */
    public List<FriendDto> getApplyFriends(ImClient currentClient) {
        if (currentClient == null) {
            throw new BusinessException("当前登录用户未找到");
        }
        List<ImFriendApplyDto> friendInfos = imFriendService.getApplyFriends(currentClient);

        List<FriendDto> friendDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(friendInfos)) {
            return friendDtoList;
        }
        List<String> friendClientIds = friendInfos.stream().map(ImFriendBaseDto::getFriendClientId).collect(Collectors.toList());
        List<User> userList = userService.list(
                new QueryWrapper<User>().lambda()
                        .in(User::getId, friendClientIds)
        );
        if (CollectionUtils.isEmpty(userList)) {
            return friendDtoList;
        }
        Map<String, User> userMap = Maps.newHashMap();
        for (User user : userList) {
            userMap.put(user.getId().toString(), user);
        }
        for (ImFriendApplyDto record : friendInfos) {
            FriendDto friendDto = new FriendDto();
            BeanUtils.copyProperties(record, friendDto);
            User user = userMap.get(record.getFriendClientId());
            if (user != null) {
                friendDto.setIdNumber(user.getIdNumber());
                friendDto.setHeadPortrait(user.getHeadPortrait());
                friendDto.setNickname(user.getNickname());
            }
            friendDtoList.add(friendDto);
        }
        return friendDtoList;
    }


}
