package io.geekidea.springbootplus.framework.shiro.signature;

import org.apache.commons.collections4.SetUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

/**
 *
 * @Author luozh
 * @Date 2022年04月15日 17:21
 * @Version 1.0
 */
public class SignatureAuthRealm extends AuthorizingRealm {

    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        // 设置角色
        authorizationInfo.setRoles(SetUtils.hashSet("client:all"));
        return authorizationInfo;
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        // 校验token
        SignatureAuthToken token = (SignatureAuthToken) authenticationToken;
        if (token == null) {
            throw new AuthenticationException("token不能为空");
        }
        return new SimpleAuthenticationInfo(
                token,
                token.getCredentials(),
                getName()
        );
    }


    @Override
    public boolean supports(AuthenticationToken token) {
        return token instanceof SignatureAuthToken;
    }
}
