package com.wecloud.im.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.param.ImConversationPageParam;
import com.wecloud.im.param.ImConversationQueryParam;
import com.wecloud.im.param.ImConversationQueryVo;
import com.wecloud.im.param.MutedGroupParam;
import com.wecloud.im.param.SetAdminsParam;
import com.wecloud.im.param.TransferOwnerParam;
import com.wecloud.im.param.add.ImClientLeaveConversation;
import com.wecloud.im.param.add.ImClientToConversation;
import com.wecloud.im.param.add.ImConversationAttrUpdate;
import com.wecloud.im.param.add.ImConversationCreate;
import com.wecloud.im.param.add.ImConversationDisplayUpdate;
import com.wecloud.im.param.add.ImConversationNameUpdate;
import com.wecloud.im.vo.ImConversationCreateVo;
import com.wecloud.im.vo.ConversationVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 会话表 服务类
 *
 * @author wei
 * @since 2021-05-07
 */
public interface ImConversationService extends BaseService<ImConversation> {

    /**
     * 保存
     *
     * @param imConversation
     * @return
     * @throws Exception
     */
    boolean saveImConversation(ImConversation imConversation) throws Exception;


    /**
     * 创建会话
     *
     * @param imConversationCreate
     * @return
     */
    ApiResult<ImConversationCreateVo> createImConversation(ImConversationCreate imConversationCreate);


    /**
     * 将用户添加进会话
     *
     * @param imClientToConversation
     * @return
     * @throws JsonProcessingException
     */
    ApiResult<Boolean> addClientToConversation(ImClientToConversation imClientToConversation);

    /**
     * 将client从会话移除
     *
     * @param imClientToConversation
     * @return
     */
    ApiResult<Boolean> delClientToConversation(ImClientToConversation imClientToConversation) throws Exception;

    /**
     * client退出会话
     */
    ApiResult<Boolean> leaveConversation(ImClientLeaveConversation imClientToConversation) throws Exception;

    /**
     * 群主转让
     * @param param
     * @return
     */
    Boolean transferOwner(@RequestBody TransferOwnerParam param);

    /**
     * 设置管理员
     * @param param
     * @return
     */
    Boolean setAdmins(@RequestBody SetAdminsParam param);

    /**
     * 群禁言
     * @param param
     * @return
     */
    Boolean mutedGroup(@RequestBody MutedGroupParam param);

    /**
     * 选择禁言
     * @param param
     * @return
     */
    Boolean mutedGroupMember(@RequestBody MutedGroupParam param);

    /**
     * 判断当前操作人是否为指定角色成员
     * @param currentClientId
     * @param conversationId
     * @param roles
     * @return
     */
    Boolean isBelongToRole(String currentClientId, Long conversationId, List<Integer> roles);

    /**
     * 添加或修改会话名称
     */
    ApiResult<Boolean> saveOrUpdateName(ImConversationNameUpdate imConversationNameUpdate) throws Exception;

    /**
     * 添加或修改会话拓展字段
     */
    ApiResult<Boolean> saveOrUpdateAttr(ImConversationAttrUpdate imConversationAttrUpdate) throws Exception;

    /**
     * 修改
     *
     * @param imConversation
     * @return
     * @throws Exception
     */
    boolean updateImConversation(ImConversation imConversation) throws Exception;

    /**
     * 修改为 是否单向隐藏会话","云端聊天记录不删除;假设有A和B两个用户,A删会话,B还能发; 如果B发了消息,A这边要重新把会话显示出来,并能显示之前的聊天记录"
     *
     * @return
     * @throws Exception
     */
    boolean updateDisplayConversation(ImConversationDisplayUpdate imConversationDisplayUpdate);

    /**
     * 根据ID获取查询对象 (redis缓存)
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImConversationQueryVo getCacheImConversationById(Long id);

    /**
     * 删除redis中该会话的缓存
     *
     * @param id
     */
    void deleteCacheImConversationById(Long id);


    /**
     * 获取分页对象
     *
     * @param imConversationPageParam
     * @return
     * @throws Exception
     */
    Paging<ImConversationQueryVo> getImConversationPageList(ImConversationPageParam imConversationPageParam) throws Exception;


    /**
     * 查询用户加入的所有会话 与每个会话的未读条数
     *
     * @return
     * @throws Exception
     */
    List<ConversationVo> getMyImConversationListAndMsgCount() throws Exception;

    /**
     * 根据会话id查询单个会话信息 与会话的未读条数
     * @param param
     * @return
     */
    ConversationVo infoImConversationAndMsgCount(ImConversationQueryParam param) throws Exception;

    /**
     * 获取加入的所有会话
     *
     * @return
     * @throws Exception
     */
    List<ImConversation> getMyImConversationList() throws Exception;

    /**
     * 判断重复会话中的Attributes是否一样
     *
     * @param clientId1
     * @param clientId2
     * @param attributes
     * @return 大于等于1为有重复会话
     */
    Long getRepetitionConversationAttributes(Long clientId1, Long clientId2, String attributes);


}
