package com.wecloud.rtc.service;

import com.wecloud.rtc.entity.response.RtcCallResponse;
import com.wecloud.rtc.entity.response.RtcCandidateForwardResponse;
import com.wecloud.rtc.entity.response.RtcClientJoinResponse;
import com.wecloud.rtc.entity.response.RtcClientLeaveResponse;
import com.wecloud.rtc.entity.response.RtcClientRejectResponse;
import com.wecloud.rtc.entity.response.RtcSdpForwardResponse;

/**
 * WebRtc webSocket下发指令数据
 */
public interface WsRtcWrite {

    /**
     * 接收到RTC邀请
     */
    void rtcCall(RtcCallResponse rtcCallResponse, String toAppKey, String toClientId);

    /**
     * 用户状态更新事件(用户加入频道)
     */
    void clientJoin(RtcClientJoinResponse rtcClientJoinResponse, String toAppKey, String toClientId);

    /**
     * 用户状态更新事件(用户退出频道)
     */
    void clientLeave(RtcClientLeaveResponse rtcClientLeaveResponse, String toAppKey, String toClientId);

    /**
     * 用户状态更新事件(用户拒接邀请;不同意进入频道)
     */
    void clientReject(RtcClientRejectResponse rtcClientRejectResponse, String toAppKey, String toClientId);

    /**
     * SDP数据转发
     */
    void sdpForward(RtcSdpForwardResponse rtcSdpForwardResponse, String toAppKey, String toClientId);

    /**
     * candidate候选者数据转发
     */
    void candidateForward(RtcCandidateForwardResponse rtcCandidateForwardResponse, String toAppKey, String toClientId);

}
