package com.wecloud.im.friend.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.friend.entity.ImFriendRecommend;
import com.wecloud.im.friend.param.ImFriendPageParam;
import com.wecloud.im.friend.param.ImFriendRecommendDto;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Description 好友推荐关系mapper
 * @Author lixiaozhong
 * @Date 2022/1/12 11:41 上午
 */
@Repository
public interface ImFriendRecommendMapper extends BaseMapper<ImFriendRecommend> {

    IPage<ImFriendRecommendDto> getImFriendRecommendPageList(@Param("page") Page pageParam, @Param("clientId") Long clientId);

    void batchDeleteRecommend(@Param("clientId") Long clientId, @Param("fkAppId") Long fkAppId, @Param("friendClientIds") List<String> friendClientIds);

    void batchCreateRecommend(@Param("list") List<ImFriendRecommend> list);
}
