package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.jumeirah.common.entity.ContactStaff;
import com.jumeirah.common.param.ContactStaffPageParam;
import com.jumeirah.common.param.ContactStaffQueryVo;

import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;

/**
 * Mapper 接口
 *
 * @author xxx
 * @since 2020-10-27
 */
@Repository
public interface ContactStaffMapper extends BaseMapper<ContactStaff> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ContactStaffQueryVo getContactStaffById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param contactStaffPageParam
     * @param mcId
     * @return
     */
    IPage<ContactStaffQueryVo> getContactStaffPageList(
            @Param("page") Page page, @Param("param") ContactStaffPageParam contactStaffPageParam, @Param("mcId") Long mcId);

}
