package com.wecloud.im.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * 群聊设置类型枚举
 * @Author luozh
 * @Date 2022年04月27日 11:23
 * @Version 1.0
 */
public enum GroupChatSettingTypeEnum {

    /**
     * 1-禁止群成员互加好友
     */
    FORBID_ADD_FRIEND("FORBID_ADD_FRIEND", "禁止群成员互加好友"),
    /**
     * 3-禁止群成员发图片
     */
    FORBID_SEND_PIC("FORBID_SEND_PIC", "禁止群成员发图片"),
    /**
     * 4-禁止群成员发链接
     */
    FORBID_SEND_LINK("FORBID_SEND_LINK", "禁止群成员发链接"),
    /**
     * 4-禁言
     */
    MUTED("MUTED", "禁言"),

    /**
     * 5-修改群名
     */
    NAME("NAME", "修改群名"),

    /**
     * 修改群头像
     */
    HEAD_PORTRAIT("HEAD_PORTRAIT", "修改群头像"),

    ;


    GroupChatSettingTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @JsonValue
    @EnumValue
    private final String code;

    private final String desc;

}
