package com.wecloud.im.param.add;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;

/**
 * 会话表
 *
 * @author wei
 * @since 2021-05-07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImConversationCreate")
public class ImConversationCreate extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("可选	 对话的名字，可为群组命名。")
    private String name;

    @ApiModelProperty("json格式,可选	自定义属性，供开发者扩展使用。")
    private HashMap attributes;

    @ApiModelProperty("可选 邀请加入会话的客户端,如创建单聊,则填入对方的clientId")
    private List<String> clientIds;

    /**
     * @see com.wecloud.im.sdk.enums.ChatTypeEnum
     */
    @ApiModelProperty("会话属性，1：单聊，2：普通群，3：万人群, 4:聊天室")
    @NotNull(message = "会话类型不能为空")
    private Integer chatType;

    @ApiModelProperty("客户端平台: 1 web, 2 安卓, 3 ios, 4 pc-win, 5 pc-macOs, 需与生成sign时的值一致")
    private Integer platform;

}
