package com.wecloud.im.param.add;

import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.sdk.enums.ChatTypeEnum;
import com.wecloud.imserver.client.model.enums.DeviceTypeEnum;

/**
 *
 * @Author luozh
 * @Date 2022年05月07日 10:13
 * @Version 1.0
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "ImConversationCreate")
public class ServerImConversationCreate implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 可选	 对话的名字，可为群组命名。")
     */
    private String name;

    /**
     * Map格式,可选	自定义属性，供开发者扩展使用。")
     */
    private Map<String, Object> attributes;

    /**
     * 应用， 前端")
     */
    private ImApplication application;

    /**
     * 创建者 前端请求不传")
     */
    private ImClient creator;

    /**
     * 可选 成员列表
     */
    private List<ImClient> members;

    /**
     * @see com.wecloud.im.sdk.enums.ChatTypeEnum
     */
    /**
     * 会话属性，1：单聊，2：普通群，3：万人群, 4:聊天室")
     */
    private ChatTypeEnum chatType;

    /**
     * 客户端平台: 1 web, 2 安卓, 3 ios, 4 pc-win, 5 pc-macOs, 需与生成sign时的值一致")
     */
    private DeviceTypeEnum platform;
}
