package com.wecloud.im.externalaccess.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author wenzhida
 * @Date 2022/2/21 18:15
 * @Description 用户注册入参
 */
@Data
public class UserRegisterParam implements Serializable {

    private static final long serialVersionUID = 6026490500445982659L;
    
    /**
     * 电话号码
     */
    @NotNull(message = "电话号码不可为空")
    @ApiModelProperty("电话号码")
    private String phone;

    /**
     * 验证码
     */
    @NotNull(message = "验证码不可为空")
    @ApiModelProperty("验证码")
    private String verifyCode;
    
    /**
     * 密码
     */
    @NotNull(message = "密码不可为空")
    @ApiModelProperty("密码")
    private String password;
    
}
