package com.wecloud.im.sdk.enums;

/**
 * 群聊设置类型枚举
 * @Author luozh
 * @Date 2022年04月27日 11:23
 * @Version 1.0
 */
public enum GroupChatSettingTypeEnum {

    /**
     * 1-禁止群成员互加好友
     */
    FORBID_ADD_FRIEND(1, "禁止群成员互加好友"),
    /**
     * 3-禁止群成员发图片
     */
    FORBID_SEND_PIC(2, "禁止群成员发图片"),
    /**
     * 4-禁止群成员发链接
     */
    FORBID_SEND_LINK(3, "禁止群成员发链接"),

    /**
     * 4-禁言
     */
    MUTED(4, "禁言"),

    /**
     * 5-修改群名
     */
    NAME(5, "修改群名"),

    /**
     * 修改群头像
     */
    HEAD_PORTRAIT(6, "修改群头像"),
    ;


    GroupChatSettingTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;

    private final String desc;


    public Integer getCode() {
        return null;
    }

    public String getDesc() {
        return null;
    }
}
