package com.ym.im.entity;

import com.ym.im.validation.group.ChatRecordReceiveGroup;
import com.ym.im.validation.group.ChatRecordSaveGroup;
import com.ym.im.validation.group.ChatRecordSendGroup;
import com.ym.im.validation.group.StaffSendGroup;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.groups.Default;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 聊天记录
 * </p>
 *
 * @author 陈俊雄
 * @since 2019-05-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ChatRecord implements Serializable {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "以用户为第一人称：发送")
    public static final int SEND = 0;

    @ApiModelProperty(value = "以用户为第一人称：接收")
    public static final int RECEIVE = 1;

    @NotNull(message = "{error.chat_id_empty}", groups = {Default.class, ChatRecordSaveGroup.class})
    @Positive(message = "{error.chat_id_greater_than_zero}", groups = {Default.class, ChatRecordSaveGroup.class})
    private Long id;

    @NotNull(message = "{error.user_id_empty}", groups = {Default.class, ChatRecordSaveGroup.class, StaffSendGroup.class})
    @Positive(message = "{error.user_id_greater_than_zero}", groups = {Default.class, ChatRecordSaveGroup.class, StaffSendGroup.class})
    @ApiModelProperty(value = "用户Id")
    private Long userId;

    @NotNull(message = "{error.staff_id_empty}", groups = {Default.class})
    @Positive(message = "{error.staff_id_greater_than_zero}", groups = {Default.class})
    @ApiModelProperty(value = "员工（客服）Id")
    private Long staffId;

    @NotNull(message = "{error.merchant_id_empty}", groups = {Default.class})
    @Positive(message = "{error.merchant_id_greater_than_zero}", groups = {Default.class})
    @ApiModelProperty(value = "商户ID")
    private Long merchantId;

    @NotNull(message = "{error.chat_msg_type_empty}", groups = {Default.class, ChatRecordSaveGroup.class, ChatRecordSendGroup.class})
    @ApiModelProperty(value = "消息类型：1、聊天信息，2、PDF")
    private Integer msgType;

    @ApiModelProperty(value = "信息内容：msg_type为聊天信息时为聊天内容，msg_type为PDF时为下载地址")
    private String msgInfo;

    @Min(value = 0, message = "{error.chat_send_receive}", groups = {Default.class, ChatRecordSaveGroup.class})
    @Max(value = 1, message = "{error.chat_send_receive}", groups = {Default.class, ChatRecordSaveGroup.class})
    @ApiModelProperty(value = "收或发（以用户为第一人称,0:用户 1:客服）")
    private Integer sendReceive;

    @Min(value = 0, message = "{error.chat_scope}", groups = {Default.class, ChatRecordSaveGroup.class})
    @Max(value = 2, message = "{error.chat_scope}", groups = {Default.class, ChatRecordSaveGroup.class})
    @ApiModelProperty(value = "内容范围: 1、机票，2、酒店等")
    private Integer scope = 0;

    @ApiModelProperty(value = "重试次数")
    private Integer retryCount = 0;

    @NotNull(message = "{error.chat_send_time_empty}", groups = {Default.class, ChatRecordSaveGroup.class, ChatRecordSendGroup.class})
    @ApiModelProperty(value = "发送时间（前端设置）")
    private Date sendTime;

    @NotNull(message = "{error.chat_receive_time_empty}", groups = {Default.class, ChatRecordReceiveGroup.class})
    @ApiModelProperty(value = "接收时间（前端设置）")
    private Date receiveTime;

    @NotNull(message = "{error.chat_create_time_empty}", groups = {Default.class, ChatRecordSaveGroup.class})
    @ApiModelProperty(value = "创建时间（服务端设置）")
    private Date createTime;

    @NotNull(message = "{error.chat_modify_time_empty}", groups = {Default.class})
    @ApiModelProperty(value = "修改时间（服务端设置）")
    private Date modifyTime;

}
