package com.wecloud.rtc.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.param.rtc.CandidateForwardParam;
import com.wecloud.im.param.rtc.CreateRtcChannelParam;
import com.wecloud.im.param.rtc.CreateRtcChannelResult;
import com.wecloud.im.param.rtc.JoinRtcChannelParam;
import com.wecloud.im.param.rtc.LeaveRtcChannelParam;
import com.wecloud.im.param.rtc.RejectRtcChannelParam;
import com.wecloud.im.param.rtc.SdpForwardParam;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.ws.service.MangerChannelService;
import com.wecloud.rtc.entity.response.RtcCallResponse;
import com.wecloud.rtc.entity.response.RtcCandidateForwardResponse;
import com.wecloud.rtc.entity.response.RtcSdpForwardResponse;
import com.wecloud.rtc.service.MangerRtcCacheService;
import com.wecloud.rtc.service.RtcService;
import com.wecloud.rtc.service.WsRtcWrite;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.shiro.util.SnowflakeUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Slf4j
@Service
public class RtcServiceImpl implements RtcService {

    @Autowired
    private ImApplicationService imApplicationService;

    @Autowired
    private WsRtcWrite wsRtcWrite;

    /**
     * redis缓存
     */
    @Autowired
    private MangerRtcCacheService mangerRtcCacheService;

    @Autowired
    private ImClientService imClientService;

    @Autowired
    private MangerChannelService mangerChannelService;

    @Override
    public ApiResult<CreateRtcChannelResult> createAndCall(CreateRtcChannelParam createRtcChannelParam) throws JsonProcessingException {
        ImClient client = imClientService.getCurentClient();
        Long rtcChannelId = SnowflakeUtil.getId();

        //  根据appKey查询appid
        ImApplication imApplication = imApplicationService.getById(client.getFkAppid());

        //  判断发起方必须在线
        boolean onlineStatus = mangerChannelService.getOnlineStatus(imApplication.getAppKey(), client.getClientId());
        if (!onlineStatus) {
            log.info("发起方必须在线" + imApplication.getAppKey() + client.getClientId());
            ApiResult.fail();
        }

        // 添加缓存
        mangerRtcCacheService.create(imApplication.getAppKey(), client.getClientId(), rtcChannelId);

        CreateRtcChannelResult createRtcChannelResult = new CreateRtcChannelResult();
        createRtcChannelResult.setChannelId(rtcChannelId);

        // ws向接收方发送通知
        RtcCallResponse rtcCallResponse = new RtcCallResponse();
        rtcCallResponse.setType(createRtcChannelParam.getType());
//        rtcCallResponse.setConversationId(createRtcChannelParam.getConversationId());
        rtcCallResponse.setChannelId(rtcChannelId);
        rtcCallResponse.setClientId(client.getClientId());
        rtcCallResponse.setTimestamp(new Date().getTime());
        wsRtcWrite.rtcCall(rtcCallResponse, imApplication.getAppKey(), createRtcChannelParam.getToClient());

        // TODO 待开发 下发安卓和ios系统推送

        return ApiResult.ok(createRtcChannelResult);


    }

    @Override
    public ApiResult<Boolean> join(JoinRtcChannelParam joinRtcChannelParam) {

        ImClient client = imClientService.getCurentClient();

        //  根据appKey查询appid
        ImApplication imApplication = imApplicationService.getById(client.getFkAppid());

        // 修改缓存
        mangerRtcCacheService.join(imApplication.getAppKey(), client.getClientId(), joinRtcChannelParam.getChannelId());

        return null;
    }

    @Override
    public ApiResult<Boolean> reject(RejectRtcChannelParam rejectRtcChannelParam) {
        return null;
    }

    @Override
    public ApiResult<Boolean> leave(LeaveRtcChannelParam leaveRtcChannelParam) {
        return null;
    }

    @Override
    public ApiResult<Boolean> sdpForward(SdpForwardParam sdpForwardParam) {

        ImClient client = imClientService.getCurentClient();
        Long rtcChannelId = SnowflakeUtil.getId();

        //  根据appKey查询appid
        ImApplication imApplication = imApplicationService.getById(client.getFkAppid());

        //  判断发起方必须在线
        boolean onlineStatus = mangerChannelService.getOnlineStatus(imApplication.getAppKey(), client.getClientId());
        if (!onlineStatus) {
            log.info("发起方必须在线" + imApplication.getAppKey() + client.getClientId());
            ApiResult.fail();
        }

        CreateRtcChannelResult createRtcChannelResult = new CreateRtcChannelResult();
        createRtcChannelResult.setChannelId(rtcChannelId);

        //获取频道内所有client
        List<String> clientListByRtcChannelId = mangerRtcCacheService.getClientListByRtcChannelId(sdpForwardParam.getChannelId());
        // 移除自己
        clientListByRtcChannelId.remove(imApplication.getAppKey() + client.getClientId());

        for (String id : clientListByRtcChannelId) {

            // ws向接收方发送通知
            RtcSdpForwardResponse rtcSdpForwardResponse = new RtcSdpForwardResponse();
            rtcSdpForwardResponse.setSdpData(sdpForwardParam.getSdpData());
            rtcSdpForwardResponse.setSdpType(sdpForwardParam.getSdpType());

//        rtcSdpForwardResponse.setConversationId(createRtcChannelParam.getConversationId());
            rtcSdpForwardResponse.setChannelId(rtcChannelId);
            rtcSdpForwardResponse.setClientId(client.getClientId());
            rtcSdpForwardResponse.setTimestamp(new Date().getTime());
            wsRtcWrite.sdpForward(rtcSdpForwardResponse, imApplication.getAppKey(), id);
        }


        return null;
    }

    @Override
    public ApiResult<Boolean> candidateForward(CandidateForwardParam candidateForwardParam) {

        ImClient client = imClientService.getCurentClient();
        Long rtcChannelId = SnowflakeUtil.getId();

        //  根据appKey查询appid
        ImApplication imApplication = imApplicationService.getById(client.getFkAppid());

        //  判断发起方必须在线
        boolean onlineStatus = mangerChannelService.getOnlineStatus(imApplication.getAppKey(), client.getClientId());
        if (!onlineStatus) {
            log.info("发起方必须在线" + imApplication.getAppKey() + client.getClientId());
            ApiResult.fail();
        }

        CreateRtcChannelResult createRtcChannelResult = new CreateRtcChannelResult();
        createRtcChannelResult.setChannelId(rtcChannelId);

        //获取频道内所有client
        List<String> clientListByRtcChannelId = mangerRtcCacheService.getClientListByRtcChannelId(candidateForwardParam.getChannelId());
        // 移除自己
        clientListByRtcChannelId.remove(imApplication.getAppKey() + client.getClientId());

        for (String id : clientListByRtcChannelId) {

            // ws向接收方发送通知
            RtcCandidateForwardResponse rtcCandidateForwardResponse = new RtcCandidateForwardResponse();

            rtcCandidateForwardResponse.setCandidateData(candidateForwardParam.getCandidateData());

//        rtcCandidateForwardResponse.setConversationId(createRtcChannelParam.getConversationId());
            rtcCandidateForwardResponse.setChannelId(rtcChannelId);
            rtcCandidateForwardResponse.setClientId(client.getClientId());
            rtcCandidateForwardResponse.setTimestamp(new Date().getTime());
            wsRtcWrite.candidateForward(rtcCandidateForwardResponse, imApplication.getAppKey(), id);
        }


        return null;
    }


}
