package com.wecloud.rtc.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.wecloud.im.ws.utils.RedisUtils;
import com.wecloud.rtc.entity.redis.RtcChannelInfo;
import com.wecloud.rtc.entity.redis.RtcRedisKey;
import com.wecloud.rtc.service.MangerRtcCacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

@Service
public class MangerRtcCacheServiceImpl implements MangerRtcCacheService {

    @Autowired
    private RedisUtils redisUtils;


    @Override
    public boolean isEmpty(String appKey, String clientId, Long rtcChannelId) {
        List<String> clientListByRtcChannelId = getClientListByRtcChannelId(rtcChannelId);

        // 移除自己
        clientListByRtcChannelId.remove(appKey + clientId);
        return clientListByRtcChannelId.isEmpty();
    }

    @Override
    public void create(String appKey, String clientId, Long rtcChannelId) throws JsonProcessingException {

        // --- 频道信息
        RtcChannelInfo rtcChannelInfo = new RtcChannelInfo();
        //当前房主
        rtcChannelInfo.setOwner(appKey + clientId);
        //创建时间
        rtcChannelInfo.setCreateTimestamp(new Date().getTime());

        String rtcChannelInfoJson = new JsonMapper().writeValueAsString(rtcChannelInfo);

        // --- 保存频道信息
        redisUtils.setKey(RtcRedisKey.RTC_CHANNEL_INFO, rtcChannelInfoJson);


        //用户当前在线的频道ID
        String userJoinChannelKey = String.format(RtcRedisKey.USER_JOIN_CHANNEL, appKey + clientId);
        redisUtils.setKey(userJoinChannelKey, rtcChannelId.toString());

        //频道中存在的用户
        String rtcChannelUsers = String.format(RtcRedisKey.RTC_CHANNEL_USERS, rtcChannelId);
        redisUtils.addForSet(rtcChannelUsers, appKey + clientId);

    }

    @Override
    public void join(String appKey, String clientId, Long rtcChannelId) {

        //用户当前在线的频道ID
        String userJoinChannelKey = String.format(RtcRedisKey.USER_JOIN_CHANNEL, appKey + clientId);
        redisUtils.setKey(userJoinChannelKey, rtcChannelId.toString());

        //频道中存在的用户
        String rtcChannelUsers = String.format(RtcRedisKey.RTC_CHANNEL_USERS, rtcChannelId);
        redisUtils.addForSet(rtcChannelUsers, appKey + clientId);
    }


    @Override
    public void remove(String appKey, String clientId, Long rtcChannelId) {

        //用户当前在线的频道ID
        String userJoinChannelKey = String.format(RtcRedisKey.USER_JOIN_CHANNEL, appKey + clientId);
        redisUtils.delKey(userJoinChannelKey);

        //频道中存在的用户
        String rtcChannelUsers = String.format(RtcRedisKey.RTC_CHANNEL_USERS, rtcChannelId);
        redisUtils.removeForSet(rtcChannelUsers, appKey + clientId);
    }

    @Override
    public List<String> getClientListByRtcChannelId(Long rtcChannelId) {

        //频道中存在的用户
        String rtcChannelUsers = String.format(RtcRedisKey.RTC_CHANNEL_USERS, rtcChannelId);

        Set<String> forSetMembers = redisUtils.getForSetMembers(rtcChannelUsers);

        return new ArrayList<>(forSetMembers);

    }


//    @Override
//    public Long getRtcChannelIdListByClientId(String appKey, String clientId) {
//
//        //用户当前在线的频道ID
//        String userJoinChannelKey = String.format(RtcRedisKey.USER_JOIN_CHANNEL, appKey + clientId);
//        String key = redisUtils.getKey(userJoinChannelKey);
//
//        return Long.valueOf(key);
//    }

    @Override
    public boolean getBusyStatus(String appKey, String clientId) {

        //用户当前在线的频道ID
        String userJoinChannelKey = String.format(RtcRedisKey.USER_JOIN_CHANNEL, appKey + clientId);

        String key = redisUtils.getKey(userJoinChannelKey);

        return key != null && !key.isEmpty();

    }
}
