package com.wecloud.im.sdk.common;

import java.util.LinkedHashMap;
import java.util.Map;

import com.wecloud.im.sdk.model.WebServiceRequest;

/**
 * Represent HTTP requests sent to wecloud im PAAS.
 */
public class RequestMessage extends HttpMesssage {

    /**
     * The service endpoint to which this request should be sent
     */
    private String endpoint;

    /**
     * client id
     */
    private String clientId;

    /**
     * 平台
     */
    private String platform;

    /**
     * The HTTP method to use when sending this request
     */
    private HttpMethod method = HttpMethod.GET;

    /**
     * Use a LinkedHashMap to preserve the insertion order.
     */
    private Map<String, Object> parameters = new LinkedHashMap<>();

    /**
     * The original request provided by user
     */
    private final WebServiceRequest originalRequest;

    public RequestMessage(WebServiceRequest originalRequest) {
        this.originalRequest = (originalRequest == null) ? WebServiceRequest.NOOP : originalRequest;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public HttpMethod getMethod() {
        return method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public WebServiceRequest getOriginalRequest() {
        return originalRequest;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Map<String, Object> getParameters() {
        return parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters.clear();
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.putAll(parameters);
        }
    }
}
