package com.wecloud.im.action;

import com.alibaba.fastjson.JSON;
import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.im.param.rtc.*;
import com.wecloud.im.sdk.enums.CallTypeEnum;
import com.wecloud.im.service.ImRtcRecordService;
import com.wecloud.im.vo.MissedRtcRecordVO;
import com.wecloud.im.ws.model.WsResponse;
import com.wecloud.rtc.service.RtcService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.enums.BaseEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

@Slf4j
@Component
@ActionMapping(value = "/im/rtc")
@Api(value = "ws-音视频通话", tags = {"ws-音视频通话"})
public class RtcAction {

    @Autowired
    private RtcService rtcService;

    @Autowired
    private ImRtcRecordService rtcRecordService;

    /**
     * 创建频道,并邀请客户端加入
     */
    @ActionMapping("/createAndCall")
    @ApiOperation(value = "创建频道,并邀请客户端加入", notes = "创建频道,并邀请客户端加入")
    public WsResponse<CreateRtcChannelResult> createAndCall(CreateRtcChannelParam data) {
        log.info("音频通话，创建频道并邀请客户端加入，入参 {}", JSON.toJSONString(data));
        if (BaseEnum.valueOf(CallTypeEnum.class, data.getCallType()) == null) {
            return WsResponse.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        return WsResponse.ok(rtcService.createAndCall(data));
    }


    @ActionMapping("/join")
    @ApiOperation(value = "同意进入频道", notes = "")
    public WsResponse<Map<String, Boolean>> join(JoinRtcChannelParam data) {
        log.info("音频通话，同意进入频道，入参 {}", JSON.toJSONString(data));
        rtcService.join(data);
        return WsResponse.ok();
    }

    @ActionMapping("/reject")
    @ApiOperation(value = "拒接进入频道", notes = "")
    public WsResponse<Map<String, Boolean>> reject(RejectRtcChannelParam data) {
        log.info("音频通话，拒接进入频道，入参 {}", JSON.toJSONString(data));
        rtcService.reject(data);
        return WsResponse.ok();
    }

    @ActionMapping("/leave")
    @ApiOperation(value = "主动挂断(离开频道)", notes = "")
    public WsResponse<Map<String, Boolean>> leave(LeaveRtcChannelParam data) {
        log.info("音频通话，主动挂断(离开频道)，入参 {}", JSON.toJSONString(data));
        rtcService.leave(data);
        return WsResponse.ok();
    }

    @ActionMapping("/sdpForward")
    @ApiOperation(value = "SDP数据转发", notes = "")
    public WsResponse<Map<String, Boolean>> sdpForward(SdpForwardParam data) {
        log.info("音频通话，SDP数据转发，入参 {}", JSON.toJSONString(data));
        rtcService.sdpForward(data);
        return WsResponse.ok();
    }

    @ActionMapping("/candidateForward")
    @ApiOperation(value = "candidate候选者数据转发", notes = "")
    public WsResponse<Map<String, Boolean>> candidateForward(CandidateForwardParam data) {
        log.info("音频通话，candidate候选者数据转发，入参 {}", JSON.toJSONString(data));
        rtcService.candidateForward(data);
        return WsResponse.ok();
    }

    @ApiOperation("未接音视频")
    @ActionMapping("/missedConversation")
    public WsResponse<MissedRtcRecordVO> missedConversation(){
        MissedRtcRecordVO missedRtcRecord = rtcRecordService.getMissedRtcRecord();
        return WsResponse.ok(missedRtcRecord);
    }
}
