package com.wecloud.im.friend.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

import javax.validation.constraints.NotNull;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

/**
 * @author lixiaozhong
 * 好友关系表
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImFriend对象")
public class ImFriend extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "主键id不能为空")
    @ApiModelProperty("主键id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("我的client-id")
    private String clientId;

    @ApiModelProperty("好友的client-id")
    private String clientIdFriend;

    @ApiModelProperty("申请者")
    private String clientIdClaimer;

    @ApiModelProperty("好友的昵称备注")
    private String friendName;

    @ApiModelProperty("好友拒绝原因")
    private String rejectRemark;

    @ApiModelProperty("好友请求说明")
    private String requestRemark;

    /**
     * 好友关系状态
     * @see com.wecloud.im.sdk.enums.FriendStateEnum
     */
    @ApiModelProperty("好友关系状态")
    private Integer state;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

}
