package com.ym.im.factory;

import com.ym.im.entity.enums.RoleEnum;
import com.ym.im.service.ChatService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author: JJww
 * @Date:2019-05-23
 */
@Component
public class SingleChatFactory {

    @Autowired
    private ChatService userSingleChatServiceImpl;

    @Autowired
    private ChatService staffSingleChatServiceImpl;

    /**
     * 创建对应实现类
     *
     * @param type
     * @return
     */
    public ChatService getService(String type) {
        switch (RoleEnum.get(type)) {
            case APP:
                return userSingleChatServiceImpl;
            case merchant:
                return staffSingleChatServiceImpl;
            default:
                return null;

        }
    }
}


