package com.wecloud.im.ws.cache;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

/**
 * @author hewei123@163.com
 * @Description 用户与redis绑定
 * @createTime 2020年04月14日 16:21:00
 */
@Service
@Slf4j
public class UserCache {

//    @Autowired
//    private RedisUtils redisUtils;
    /**
     * 在线状态
     */
    public static final Integer ONLINE = 1;
    /**
     * 离线状态
     */
    public static final Integer OFFLINE = 0;

    /**
     * key name
     */
    private static final String KEY_BASE = "wsu:";

    /**
     * 用户在线状态fieldKey
     */
    private static final String ONLINE_STATUS_KEY = "st";
    /**
     * 用户所连机器ip的fieldKey
     */
    private static final String PRIVATE_IP_KEY = "lip";

    // 用户语言暂时没用到
    //    private static final String LANGUAGE = "la";
    // 用户公网ip，在公网部署集群需要用到
    //    private static final String PUBLIC_IP = "iip";
    /**
     * 排除无效的mac地址
     */
    private final static byte[][] INVALID_MACS = {
            {0x00, 0x05, 0x69},             // VMWare
            {0x00, 0x1C, 0x14},             // VMWare
            {0x00, 0x0C, 0x29},             // VMWare
            {0x00, 0x50, 0x56},             // VMWare
            {0x08, 0x00, 0x27},             // Virtualbox
            {0x0A, 0x00, 0x27},             // Virtualbox
            {0x00, 0x03, (byte) 0xFF},       // Virtual-PC
            {0x00, 0x15, 0x5D}              // Hyper-V
    };
    /**
     * 内网ip
     */
    private static String lAN_IP = "";

    // 获取机器内网ip
    static {
        lAN_IP = getLocalIpAddress();
        log.debug("lAN_IP:" + lAN_IP);
    }

    /**
     * 判断是否为虚拟mac地址
     *
     * @param mac
     * @return
     */
    public static boolean isVmMac(byte[] mac) {
        if (null == mac) {
            return false;
        }

        for (byte[] invalid : INVALID_MACS) {
            if (invalid[0] == mac[0] && invalid[1] == mac[1] && invalid[2] == mac[2]) {
                return true;
            }
        }

        return false;
    }

    /**
     * 获取本机地址
     */
    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();

                /*
                    排除docker虚拟网卡
                 */
                String docker0 = "docker0";
                if (ni.getName().equals(docker0)) {
                    continue;
                }
                if (!ni.isUp() || ni.isLoopback() || ni.isVirtual()) {
                    continue;
                }

                if (isVmMac(ni.getHardwareAddress())) {
                    continue;
                }
                Enumeration<InetAddress> inetAddresses = ni.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLinkLocalAddress()) {
                        continue;
                    }
                    return inetAddress.getHostAddress();
                }
            }
        } catch (SocketException e) {
            log.debug("获取本机IP地址失败。" + e);


        }
        return StringUtils.EMPTY;
    }


    /**
     * 用户上线绑定机器ip
     *
     * @param id
     */
    public void online(String id) {
        log.debug("ws用户上线保存redis连接ip:" + lAN_IP, ",uid:" );
//        redisUtils.hset(KEY_BASE + id, PRIVATE_IP_KEY, lAN_IP);
//        redisUtils.hset(KEY_BASE + id, ONLINE_STATUS_KEY, String.valueOf(ONLINE));
    }

    /**
     * 用户下线删除绑定机器ip
     *
     * @param id
     */
    public void offline(String id) {
        log.debug("ws用户离线删除redis key,uid:" + id);

//        redisUtils.kdel(KEY_BASE + id);
    }

//    /**
//     * 根据用户id获取存在redis中的数据 例如绑定的服务器ip地址
//     *
//     * @param id
//     * @return
//     */
//    public AppHashValueModel getById(String id) {
//
//        Map<String, String> hgetll = redisUtils.hgetll(KEY_BASE + id);
//        if (hgetll.isEmpty()) {
//            return null;
//        }
//        AppHashValueModel appHashValueModel = new AppHashValueModel();
//        appHashValueModel.setLanIp(hgetll.get(PRIVATE_IP_KEY));
//        appHashValueModel.setOnlineStatus(Integer.parseInt(hgetll.get(ONLINE_STATUS_KEY)));
//        return appHashValueModel;
//
//    }
//

}
