package com.wecloud.im.sdk.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;

/**
 * @Description 会话类型
 * @Author lixiaozhong
 * @Date 2022/1/11 4:58 下午
 */
public enum ChatTypeEnum implements BaseEnum {

    SINGLE(1, "单聊"),
    NORMAL_GROUP(2, "普通群"),
    THOUSAND_GROUP(3, "万人群"),
    CHAT_ROOM(4, "聊天室");

    private final Integer code;
    private final String desc;

    ChatTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
