package com.wecloud.im.friend.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.friend.entity.ImFriend;
import com.wecloud.im.friend.param.ImFriendApplyDto;
import com.wecloud.im.friend.param.ImFriendBaseDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Description 好友关系mapper
 * @Author lixiaozhong
 * @Date 2022/1/12 11:41 上午
 */
@Repository
public interface ImFriendMapper extends BaseMapper<ImFriend> {

    IPage<ImFriendBaseDto> getImFriendPageList(@Param("page") Page<ImFriendBaseDto> page, @Param("clientId") Long clientId);

    IPage<ImFriendApplyDto> getUnsureFriendPageList(@Param("page") Page<ImFriendApplyDto> page, @Param("clientId") Long clientId);

    ImFriendApplyDto getFriendInfo(@Param("clientId") Long clientId, @Param("friendClientId") Long friendClientId);

    void batchDeleteFriend(@Param("clientId") Long clientId, @Param("fkAppId") Long fkAppId, @Param("friendClientIds") List<String> friendClientIds);
}
