package com.wecloud.im.controller;

import com.wecloud.im.param.add.ImClientLeaveConversation;
import com.wecloud.im.param.add.ImClientToConversation;
import com.wecloud.im.param.add.ImConversationAttrUpdate;
import com.wecloud.im.param.add.ImConversationCreate;
import com.wecloud.im.param.add.ImConversationDisplayUpdate;
import com.wecloud.im.param.add.ImConversationNameUpdate;
import com.wecloud.im.service.ImConversationService;
import com.wecloud.im.vo.ImConversationCreateVo;
import com.wecloud.im.vo.MyConversationListVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 会话表 控制器
 *
 * @author wei
 * @since 2021-05-07
 */
@Slf4j
@RestController
@RequestMapping("/conversation")
@Api(value = "会话表API", tags = {"会话表"})
public class ImConversationController extends BaseController {

    @Autowired
    private ImConversationService imConversationService;


    /**
     * 添加或修改会话名称
     */
    @PostMapping("/saveOrUpdateName")
    @ApiOperation(value = "添加或修改会话名称", notes = "")
    public ApiResult<Boolean> saveOrUpdateName(@RequestBody ImConversationNameUpdate imConversationNameUpdate) throws Exception {
        return imConversationService.saveOrUpdateName(imConversationNameUpdate);
    }


    /**
     * 添加或修改会话拓展字段
     */
    @PostMapping("/saveOrUpdateAttr")
    @ApiOperation(value = "添加或修改会话拓展字段", notes = "")
    public ApiResult<Boolean> saveOrUpdateAttr(@RequestBody ImConversationAttrUpdate imConversationAttrUpdate) throws Exception {
        return imConversationService.saveOrUpdateAttr(imConversationAttrUpdate);
    }


    /**
     * client退出会话
     */
    @PostMapping("/leave")
    @ApiOperation(value = "client退出会话", notes = "")
    public ApiResult<Boolean> leaveConversation(@RequestBody ImClientLeaveConversation imClientToConversation) throws Exception {
        return imConversationService.leaveConversation(imClientToConversation);
    }


    /**
     * 将client从会话移除
     */
    @PostMapping("/delClient")
    @ApiOperation(value = "将client从会话移除", notes = "")
    public ApiResult<Boolean> delClientToConversation(@RequestBody ImClientToConversation imClientToConversation) throws Exception {
        return imConversationService.delClientToConversation(imClientToConversation);
    }


    /**
     * 将用户添加进会话
     */
    @PostMapping("/addClient")
    @ApiOperation(value = "将用户添加进会话", notes = "")
    public ApiResult<Boolean> addClientToConversation(@RequestBody ImClientToConversation imClientToConversation) throws Exception {
        return imConversationService.addClientToConversation(imClientToConversation);
    }

    /**
     * 创建会话
     */
    @PostMapping("/create")
    @ApiOperation(value = "创建会话", notes = "后台可配置:两个客户端如果已经创建过会话,是否重复创建会话")
    public ApiResult<ImConversationCreateVo> createImConversation(@RequestBody ImConversationCreate imConversationCreate) throws Exception {
        return imConversationService.createImConversation(imConversationCreate);
    }

    /**
     * 查询用户加入的所有会话 与每个会话的未读条数 成员
     */
    @PostMapping("/getList")
    @ApiOperation(value = "查询加入的会话列表", notes = "查询用户加入的非隐藏状态的会话列表 与每个会话的未读条数 成员")
    public ApiResult<List<MyConversationListVo>> getMyImConversationListAndMsgCount() throws Exception {
        List<MyConversationListVo> conversationList = imConversationService.getMyImConversationListAndMsgCount();
        return ApiResult.ok(conversationList);
    }

    /**
     * 批量修改单向隐藏或显示会话
     */
    @PostMapping("/displayUpdate")
    @ApiOperation(value = "批量修改单向隐藏或显示会话", notes = "拉取会话列表不展示已隐藏状态的会话,云端聊天记录不删除;假设有A和B两个用户,A删会话,B还能发; 如果B发了消息,A这边要重新把会话显示出来,并能显示之前的聊天记录")
    public ApiResult<Boolean> updateDisplayConversation(@RequestBody ImConversationDisplayUpdate imConversationDisplayUpdate) throws Exception {

        imConversationService.updateDisplayConversation(imConversationDisplayUpdate);
        return ApiResult.result(true);
    }

//    /**
//     * 添加会话表
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加会话表", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加会话表")
//    public ApiResult<Boolean> addImConversation(@Validated(Add.class) @RequestBody ImConversation imConversation) throws Exception {
//        boolean flag = imConversationService.saveImConversation(imConversation);
//        return ApiResult.result(flag);
//    }

//    /**
//     * 修改会话表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改会话表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改会话表")
//    public ApiResult<Boolean> updateImConversation(@Validated(Update.class) @RequestBody ImConversation imConversation) throws Exception {
//        boolean flag = imConversationService.updateImConversation(imConversation);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除会话表
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除会话表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除会话表")
//    public ApiResult<Boolean> deleteImConversation(@PathVariable("id") Long id) throws Exception {
//        boolean flag = imConversationService.deleteImConversation(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取会话表详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "会话表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "会话表详情")
//    public ApiResult<ImConversationQueryVo> getImConversation(@PathVariable("id") Long id) throws Exception {
//        ImConversationQueryVo imConversationQueryVo = imConversationService.getImConversationById(id);
//        return ApiResult.ok(imConversationQueryVo);
//    }
//
//    /**
//     * 会话表分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "会话表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "会话表分页列表")
//    public ApiResult<Paging<ImConversationQueryVo>> getImConversationPageList(@Validated @RequestBody ImConversationPageParam imConversationPageParam) throws Exception {
//        Paging<ImConversationQueryVo> paging = imConversationService.getImConversationPageList(imConversationPageParam);
//        return ApiResult.ok(paging);
//    }

}

