package com.wecloud.im.event;

import lombok.Getter;

import org.springframework.context.ApplicationEvent;

/**
 * 客户端在线状态变化事件
 * @Author luozh
 * @Date 2022年04月22日 09:44
 * @Version 1.0
 */
@Getter
public class ClientOnlineStatusChangeEvent extends ApplicationEvent {


    private Long applicationId;

    private Long clientId;

    private Integer status;

    private Integer deviceType;

    private Long time;

    private String clientIp;

    /**
     * Create a new {@code ApplicationEvent}.
     * @param source the object on which the event initially occurred or with
     * which the event is associated (never {@code null})
     */
    public ClientOnlineStatusChangeEvent(Object source) {
        super(source);
    }

    public ClientOnlineStatusChangeEvent(Long applicationId, Long clientId,
                                         Integer status, Integer deviceType, Long time, String clientIp) {
        super(clientId);
        this.applicationId = applicationId;
        this.clientId = clientId;
        this.status = status;
        this.deviceType = deviceType;
        this.time = time;
        this.clientIp = clientIp;
    }
}
