package com.wecloud.im.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.shiro.signature.Application;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

import javax.validation.constraints.NotNull;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

/**
 * 第三方应用表
 *
 * @author wei
 * @since 2021-04-27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImApplication对象")
public class ImApplication extends BaseEntity implements Application {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用appid")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("key")
    private String appKey;

    @ApiModelProperty("密钥")
    private String appSecret;

    @ApiModelProperty("app名称")
    private String appName;

    @ApiModelProperty("ios推送通道,友盟:1;firebase:2; apns原生:3")
    private Integer iosPushChannel;

    @ApiModelProperty("安卓推送通道,友盟:1;firebase:2; 信鸽3")
    private Integer androidPushChannel;

    @ApiModelProperty("友盟推送key")
    private String umengKey;

    @ApiModelProperty("友盟推送密钥")
    private String umengSecret;

    @ApiModelProperty("firebase推送密钥")
    private String firebaseSecret;

    @ApiModelProperty("是否允许创建重复会话 0不允许 1允许")
    private Integer repeatSessionStatus;

    @ApiModelProperty("创建会话时对比扩展字段 0不 1是")
    private Integer contrastExtendedFieldStatus;

    @ApiModelProperty("在线状态订阅地址")
    private String onlineStatusSubscribeUrl;

    @ApiModelProperty("全量消息订阅地址")
    private String fullMessageSubscribeUrl;

    @Override
    public Boolean isActive() {
        return true;
    }
}
