package com.jumeirah.api.app.controller;

import com.jumeirah.common.entity.UserActiveRecord;
import com.jumeirah.common.service.UserActiveRecordService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

/**
 * app用户活跃记录表 控制器
 *
 * @author giao
 * @since 2020-10-21
 */
@Slf4j
@RestController
@RequestMapping("/app/userActiveRecord")
@Api(value = "app用户活跃记录表API", tags = {"app用户活跃记录表"})
public class UserActiveRecordController extends BaseController {

    @Autowired
    private UserActiveRecordService userActiveRecordService;

    /**
     * 添加app用户活跃记录表
     */
    @PostMapping("/add")
    @OperationLog(name = "添加app用户活跃记录表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加app用户活跃记录表")
    public ApiResult<Boolean> addUserActiveRecord() throws Exception {

        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();

        UserActiveRecord userActiveRecord = new UserActiveRecord();
        userActiveRecord.setUserId(jwtToken.getUserId());

        userActiveRecord.setRecordDate(new Date());

        boolean flag = userActiveRecordService.saveUserActiveRecord(userActiveRecord);
        return ApiResult.result(flag);
    }
//
//    /**
//     * 修改app用户活跃记录表
//     */
//    @PostMapping("/update")
//        @OperationLog(name = "修改app用户活跃记录表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改app用户活跃记录表")
//    public ApiResult<Boolean> updateUserActiveRecord(@Validated(Update.class) @RequestBody UserActiveRecord userActiveRecord)throws Exception{
//            boolean flag= userActiveRecordService.updateUserActiveRecord(userActiveRecord);
//            return ApiResult.result(flag);
//            }
//
//    /**
//     * 删除app用户活跃记录表
//     */
//    @PostMapping("/delete/{id}")
//        @OperationLog(name = "删除app用户活跃记录表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除app用户活跃记录表")
//    public ApiResult<Boolean> deleteUserActiveRecord(@PathVariable("id") Long id)throws Exception{
//            boolean flag= userActiveRecordService.deleteUserActiveRecord(id);
//            return ApiResult.result(flag);
//            }
//
//    /**
//     * 获取app用户活跃记录表详情
//     */
//    @GetMapping("/info/{id}")
//        @OperationLog(name = "app用户活跃记录表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "app用户活跃记录表详情")
//    public ApiResult<UserActiveRecordQueryVo> getUserActiveRecord(@PathVariable("id") Long id)throws Exception{
//            UserActiveRecordQueryVo userActiveRecordQueryVo = userActiveRecordService.getUserActiveRecordById(id);
//            return ApiResult.ok(userActiveRecordQueryVo);
//            }
//
//    /**
//     * app用户活跃记录表分页列表
//     */
//    @PostMapping("/getPageList")
//        @OperationLog(name = "app用户活跃记录表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "app用户活跃记录表分页列表")
//    public ApiResult<Paging<UserActiveRecordQueryVo>>getUserActiveRecordPageList(@Validated @RequestBody UserActiveRecordPageParam userActiveRecordPageParam)throws Exception{
//            Paging<UserActiveRecordQueryVo> paging = userActiveRecordService.getUserActiveRecordPageList(userActiveRecordPageParam);
//            return ApiResult.ok(paging);
//            }
//
}

