package com.sien.common.service;

import com.sien.common.entity.AppUser;
import com.sien.common.param.AppUserPageParam;
import com.sien.common.param.app.AppSmsRegisterParam;
import com.sien.common.param.app.DeviceTokenParam;
import com.sien.common.vo.AppUserQueryVo;
import com.sien.common.vo.app.LoginAppUserTokenVo;
import com.sien.common.vo.app.MyInfoVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import me.chanjar.weixin.common.error.WxErrorException;

;

/**
 * APP用户 服务类
 *
 * @author wei
 * @since 2020-09-23
 */
public interface AppUserService extends BaseService<AppUser> {

        /**
         * 根据手机号判断用户是否存在
         * @param phoneArea
         * @param phone
         * @return
         */
        boolean hasUserByPhoneNumer(String phoneArea,String phone);

//    /**
//     * 注册
//     *
//     * @param appSmsRegisterParam
//     * @param language
//     * @return
//     */
//    ApiResult<LoginAppUserTokenVo> register(AppSmsRegisterParam appSmsRegisterParam, String language);

        /**
         * 登陆
         *
         * @param loginParam
         * @param language
         * @return
         */
        ApiResult<LoginAppUserTokenVo> login(AppSmsRegisterParam loginParam, String language,Boolean hasRegister);


        /**
         * 保存
         *
         * @param appUser
         * @return
         * @throws Exception
         */
        boolean saveAppUser(AppUser appUser) throws Exception;

        /**
         * 修改
         *
         * @param appUser
         * @return
         * @throws Exception
         */
        boolean updateAppUser(AppUser appUser) throws Exception;

        /**
         * 添加或修改推送token
         *
         * @param deviceTokenParam
         * @param deviceType
         * @return
         * @throws Exception
         */
        boolean updateDeviceToken(DeviceTokenParam deviceTokenParam, int deviceType) throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteAppUser(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    AppUserQueryVo getAppUserById(Long id) throws Exception;


    /**
     * 获取自己的信息详情
     */
    MyInfoVo getMyInfo() throws Exception;


    /**
     * 查询用户是否绑定微信
     */
    ApiResult<LoginAppUserTokenVo> checkWechatUserBinding(String code) throws WxErrorException;


    /**
     * 获取分页对象
     *
     * @param appUserPageParam
     * @return
     * @throws Exception
     */
    Paging<AppUserQueryVo> getAppUserPageList(AppUserPageParam appUserPageParam) throws Exception;

}
