package com.sien.common.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 捐款记录
 *
 * @author hewei
 * @since 2021-02-25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "VipRecord对象")
public class VipRecord extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {Update.class})
    @ApiModelProperty("主键")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @NotNull(message = "外键_用户表不能为空")
    @ApiModelProperty("外键_用户表")
    private Long fkUserId;

    @NotNull(message = "开通人,因为可以给其他人开通,所以要有对应的谁给我充值的不能为空")
    @ApiModelProperty("开通人,因为可以给其他人开通,所以要有对应的谁给我充值的")
    private Long fkRechargeUser;

    @ApiModelProperty("开通会员金额")
    private BigDecimal money;

    @ApiModelProperty("到期时间")
    private Date expiredAt;

    @NotNull(message = "开通多久不能为空")
    @ApiModelProperty("开通多久")
    private Integer years;

    @NotBlank(message = "会员等级不能为空")
    @ApiModelProperty("会员等级")
    private String vipLevel;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("微信商家订单id")
    private String wxMerPayId;

    @ApiModelProperty("支付状态,1已支付, 0未支付")
    private Integer payStatus;

    @ApiModelProperty("支付时间")
    private Date payTime;

}
