package com.wecloud.im.user.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author wenzhida
 * @Date 2022/2/22 11:32
 * @Description 校验手机号码有效入参
 */
@Data
public class CheckPhoneParam implements Serializable {

    private static final long serialVersionUID = 5693166829929874726L;

    /**
     * 电话号码
     */
    @NotNull(message = "电话号码不可为空")
    @ApiModelProperty("电话号码")
    private String phone;

}
