package com.wecloud.im.service.impl;

import io.geekidea.springbootplus.framework.common.exception.BusinessException;
import io.geekidea.springbootplus.framework.shiro.util.SecurityUtils;
import lombok.AllArgsConstructor;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.entity.ImConversationMembers;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.service.ImConversationService;
import com.wecloud.im.service.ImGroupService;

/**
 * 群服务
 * @Author luozh
 * @Date 2022年05月10日 15:23
 * @Version 1.0
 */
@AllArgsConstructor
@Service
public class ImGroupServiceImpl implements ImGroupService {

    /**
     * 会话服务
     */
    private final ImConversationService conversationService;

    /**
     * 会话成员服务
     */
    private final ImConversationMembersService conversationMembersService;

    @Override
    public Long createGroup(String groupOwnerUserId, String groupName, List<String> memberIds) {
        return null;
    }

    @Override
    public Boolean dismissGroup(String userId, String groupId) {
        return null;
    }

    @Override
    public Boolean joinGroup(String groupId, String userIds) {
        return null;
    }

    @Override
    public Boolean leaveGroup(String groupId, String userIds) {
        return null;
    }

    @Override
    public List<String> listGroupMembers(String groupId) {
        Long appId = SecurityUtils.getCurrentAppId();
        // 获取会话
        ImConversation conversation =
                conversationService.getOne(Wrappers.<ImConversation>lambdaQuery()
                        .eq(ImConversation::getFkAppid, appId)
                        .eq(ImConversation::getId, groupId));
        if (conversation == null) {
            throw new BusinessException("群组不存在");
        }
        // 获取群成员
        List<ImConversationMembers> membersList =
                conversationMembersService.list(Wrappers.<ImConversationMembers>lambdaQuery().eq(ImConversationMembers::getFkConversationId, groupId));

        return membersList.stream().map(ImConversationMembers::getClientId).collect(Collectors.toList());
    }
}
