package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author wenzhida
 * @Date 2022/3/2 14:52
 * @Description 客户端设备
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "客户端设备")
public class ImClientDevice extends BaseEntity {

    private static final long serialVersionUID = 6988763580951760226L;

    @NotNull(message = "主键id不能为空")
    @ApiModelProperty("主键id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("client主键id")
    private Long fkClientId;

    @ApiModelProperty("设备不想收到推送提醒, 1想, 0不想")
    private Integer valid;

    @ApiModelProperty("设备类型 1:ios; 2:android; 3:web; 4:win; 5:mac")
    private Integer deviceType;

    @ApiModelProperty("设备推送token")
    private String deviceToken;

    @ApiModelProperty("唯一id")
    private String uniqueDeviceId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

}
