package com.ym.im.entity;

import com.ym.im.validation.group.ChatRecordSaveGroup;
import com.ym.im.validation.group.ChatRecordSendGroup;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

/**
 * 行程表
 *
 * @author wei
 * @since 2020-09-29
 */
@Data
@Accessors(chain = true)
public class Stroke implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("出发城市id")
    private Long cityOutsetId;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleted;

    @ApiModelProperty("出发城市名称")
    private String cityOutsetName;

    @ApiModelProperty("到达城市id")
    private Long cityArriveId;

    @ApiModelProperty("到达城市名称")
    private String cityArriveName;

    @ApiModelProperty("人数")
    private Integer peopleNum;

    @ApiModelProperty("飞机型号ID")
    private Long plainTypeId;

    @ApiModelProperty("出发时间")
    private Timestamp outsetTime;

    @ApiModelProperty("返程时间")
    private Timestamp returnTime;

    @ApiModelProperty("行程类型，0-单程，1-往返行程，2-货运，3-医疗")
    private Integer type;

    @ApiModelProperty("状态，0-审核中，1-进行中，2-已完成，99-取消")
    private Integer status;

    @ApiModelProperty("创建时间")
    private Timestamp createTime;

    @ApiModelProperty("更新时间")
    private Timestamp updateTime;

    @ApiModelProperty("付款时间")
    private Timestamp userRechargeTime;

    @ApiModelProperty("货物名称")
    private String goodsName;

    @ApiModelProperty("货物体积（长*宽*高） 单位：CM，例如：100*102*120")
    private String goodsSize;

    @ApiModelProperty("货物重量，单位：吨")
    private String goodsWeight;

    @ApiModelProperty("病人疾病名称")
    private String diseaseName;

    @ApiModelProperty("病人病情诊断书")
    private String medicalCertificateUrl;

    @ApiModelProperty("配备器械（格式：1,2,3）逗号分隔")
    private String instruments;

    @ApiModelProperty("医护人员，0-医生，1-护士，2-护工（格式：0,1,2）逗号分隔")
    private String medicalPersons;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("价格")
    private BigDecimal money;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("出发机场名称")
    private String outsetAirportName;

    @ApiModelProperty("到达机场名称")
    private String arriveAirportName;

    @ApiModelProperty("返程飞机型号ID")
    private Long arrivePlainTypeId;

    @ApiModelProperty("返程出发机场名称")
    private String backOutsetAirportName;

    @ApiModelProperty("返程到达机场名称")
    private String backArriveAirportName;

    @ApiModelProperty("商家id")
    private Long mcId;

    @ApiModelProperty("用户选择机型")
    private String choosePlainType;

    @ApiModelProperty("付款状态，0-未付款，1-付款中，2-已付款，3-退款中，99-已退款")
    private Integer paymentStatus;

    @ApiModelProperty("审核状态,0审核中,1审核通过,2审核未通过")
    private Integer auditStatus;

    @ApiModelProperty("用户充值金额")
    private BigDecimal userRechargeMoney;

    @ApiModelProperty("用户充值银行名称")
    private String userRechargeBank;

    @ApiModelProperty("用户充值账户名")
    private String userRechargeName;

    @ApiModelProperty("用户充值卡号")
    private String userRechargeBankNumber;

    @ApiModelProperty("用户充值截图证据,  传入数组")
    private String userRechargeCredentialsUrl;

    @ApiModelProperty("是否是优惠调机，0-否，1-是")
    private Boolean isDiscount;

    @ApiModelProperty(value = "发送时间")
    private Date sendTime;
}
