package com.wecloud.im.friend.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.friend.entity.ImFriend;
import com.wecloud.im.friend.param.ImFriendApplyDto;
import com.wecloud.im.friend.param.ImFriendBaseDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Description 好友关系mapper
 * @Author lixiaozhong
 * @Date 2022/1/12 11:41 上午
 */
@Repository
public interface ImFriendMapper extends BaseMapper<ImFriend> {

    IPage<ImFriendBaseDto> getImFriendPageList(@Param("page") Page<ImFriendBaseDto> page, @Param("clientId") Long fkClientId);

    IPage<ImFriendApplyDto> getUnsureFriendPageList(@Param("page") Page<ImFriendApplyDto> page, @Param("clientId") Long fkClientId);

    ImFriendApplyDto getFriendInfo(@Param("clientId") Long fkClientId, @Param("friendClientId") Long fkFriendClientId);

    /**
     * 过滤得到真的好友，非好友的friendId将被它忽略
     * @param fkClientId
     * @param fkFriendClientIds
     * @return
     */
    List<Long> filterNegativeFriends(@Param("clientId") Long fkClientId, @Param("friendClientIds") List<Long> fkFriendClientIds);

    void batchDeleteFriend(@Param("clientId") Long fkClientId, @Param("fkAppId") Long fkAppId, @Param("friendClientIds") List<String> friendClientIds);
}
