/*
 Navicat Premium Data Transfer

 Source Server         : yumeng-test
 Source Server Type    : MySQL
 Source Server Version : 50725
 Source Host           : 47.99.47.225:3306
 Source Schema         : Jumeirah

 Target Server Type    : MySQL
 Target Server Version : 50725
 File Encoding         : 65001

 Date: 09/10/2020 09:38:31
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for app_user
-- ----------------------------
DROP TABLE IF EXISTS `app_user`;
CREATE TABLE `app_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `username` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '用户名',
  `surname` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '姓',
  `name` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '名',
  `company_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '公司名称',
  `wechat` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '微信',
  `nickname` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '昵称',
  `password` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '密码',
  `salt` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '盐值',
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '手机号码',
  `phone_area` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '手机区号',
  `gender` int(11) DEFAULT '1' COMMENT '性别，0：女，1：男，默认1',
  `head` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '头像',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT '状态，0：禁用，1：启用，2：锁定',
  `department_id` bigint(20) DEFAULT NULL COMMENT '部门id',
  `role_id` bigint(20) DEFAULT NULL COMMENT '角色id',
  `deleted` int(11) NOT NULL DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT '版本',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  `date_of_birth` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '出生日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `sys_user_username_uindex` (`username`) USING BTREE,
  KEY `department_id` (`department_id`) USING BTREE,
  KEY `role_id` (`role_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='APP用户';

-- ----------------------------
-- Records of app_user
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for business_plain
-- ----------------------------
DROP TABLE IF EXISTS `business_plain`;
CREATE TABLE `business_plain` (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `business_type` int(2) NOT NULL COMMENT '业务类型，0-出售，1-托管',
  `img_url_one` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片1url',
  `img_url_two` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片2url',
  `img_url_three` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片3url',
  `introduction` text COLLATE utf8mb4_unicode_ci COMMENT '机型介绍',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '销售员姓名',
  `phone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '销售联系电话',
  `wechat` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '微信号',
  `status` int(2) NOT NULL COMMENT '状态，0-正常，1-禁用，99-删除',
  `create_time` bigint(20) NOT NULL COMMENT '创建时间（时间戳）',
  `update_time` bigint(20) DEFAULT NULL COMMENT '更新时间（时间戳）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='公务机出售/托管表';

-- ----------------------------
-- Records of business_plain
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for charter_introduction
-- ----------------------------
DROP TABLE IF EXISTS `charter_introduction`;
CREATE TABLE `charter_introduction` (
  `id` bigint(20) NOT NULL COMMENT '主键ID',
  `charter_type` int(2) NOT NULL COMMENT '包机类型',
  `img_url_one` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片1url',
  `img_url_two` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片2url',
  `img_url_three` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片3url',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '标题',
  `contents` text COLLATE utf8mb4_unicode_ci COMMENT '内容',
  `status` int(2) NOT NULL COMMENT '状态，0-正常，1-取消，99-删除',
  `create_time` bigint(20) NOT NULL COMMENT '创建时间',
  `update_time` bigint(20) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='包机介绍';

-- ----------------------------
-- Records of charter_introduction
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for foo_bar
-- ----------------------------
DROP TABLE IF EXISTS `foo_bar`;
CREATE TABLE `foo_bar` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name',
  `foo` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Foo',
  `bar` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Bar',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Remark',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT 'State，0：Disable，1：Enable',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT 'Version',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create Time',
  `update_time` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='FooBar';

-- ----------------------------
-- Records of foo_bar
-- ----------------------------
BEGIN;
INSERT INTO `foo_bar` VALUES (1, 'test add', 'hello', 'world', '备注', 1, 0, '2020-03-20 11:22:35', NULL);
COMMIT;

-- ----------------------------
-- Table structure for ip_address
-- ----------------------------
DROP TABLE IF EXISTS `ip_address`;
CREATE TABLE `ip_address` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ip_start` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_end` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `area` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '区域',
  `operator` varchar(6) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '运营商',
  `ip_start_num` bigint(10) NOT NULL,
  `ip_end_num` bigint(10) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `ip_address_ip_end_num_index` (`ip_end_num`) USING BTREE,
  KEY `ip_address_ip_start_num_index` (`ip_start_num`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='IP地址';

-- ----------------------------
-- Records of ip_address
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for mc_plain
-- ----------------------------
DROP TABLE IF EXISTS `mc_plain`;
CREATE TABLE `mc_plain` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `pt_id` bigint(20) NOT NULL COMMENT '飞机类型ID',
  `status` int(2) NOT NULL COMMENT '状态，0-正常，1-禁用，99-删除',
  `create_time` bigint(20) NOT NULL COMMENT '创建时间（时间戳）',
  `update_time` bigint(20) DEFAULT NULL COMMENT '更新时间（时间戳）',
  `mc_id` bigint(20) NOT NULL COMMENT '商家ID',
  `amount` int(6) NOT NULL COMMENT '数量',
  `city_id` bigint(20) NOT NULL COMMENT '所在地城市ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='商家飞机表';

-- ----------------------------
-- Records of mc_plain
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for merchant_permission
-- ----------------------------
DROP TABLE IF EXISTS `merchant_permission`;
CREATE TABLE `merchant_permission` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '权限名称',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父id',
  `url` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '路径',
  `code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '唯一编码',
  `icon` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图标',
  `type` int(11) NOT NULL COMMENT '类型，1：菜单，2：按钮',
  `level` int(11) NOT NULL COMMENT '层级，1：第一级，2：第二级，N：第N级',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT '状态，0：禁用，1：启用',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT '版本',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `sys_permission_code_uindex` (`code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6002 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='商家权限';

-- ----------------------------
-- Records of merchant_permission
-- ----------------------------
BEGIN;
INSERT INTO `merchant_permission` VALUES (1, '系统管理', NULL, NULL, 'system:management', 'el-icon-s-unfold', 1, 1, 1, 0, '1权限备注', 0, '2019-10-26 11:12:40', NULL);
INSERT INTO `merchant_permission` VALUES (100, '用户管理', 1, NULL, 'sys:user:management', 'el-icon-s-unfold', 1, 2, 1, 0, '100权限备注', 0, '2019-10-26 11:15:48', NULL);
INSERT INTO `merchant_permission` VALUES (200, '角色管理', 1, NULL, 'sys:role:management', 'el-icon-s-unfold', 1, 2, 1, 0, '200权限备注', 0, '2019-10-26 11:15:48', NULL);
INSERT INTO `merchant_permission` VALUES (300, '权限管理', 1, NULL, 'sys:permission:management', 'el-icon-s-unfold', 1, 2, 1, 0, '300权限备注', 0, '2019-10-26 11:15:48', NULL);
INSERT INTO `merchant_permission` VALUES (400, '部门管理', 1, NULL, 'sys:department:management', 'el-icon-s-unfold', 1, 2, 1, 0, '400权限备注', 0, '2019-10-26 11:15:48', NULL);
INSERT INTO `merchant_permission` VALUES (500, '日志管理', 1, NULL, 'sys:log:manager', 'el-icon-s-custom', 1, 2, 1, 0, '500权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (1000, '用户新增', 100, NULL, 'sys:user:add', 'el-icon-s-custom', 2, 3, 1, 0, '1000权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (1001, '用户修改', 100, NULL, 'sys:user:update', 'el-icon-s-custom', 2, 3, 1, 0, '1001权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (1002, '用户删除', 100, NULL, 'sys:user:delete', 'el-icon-s-custom', 2, 3, 1, 0, '1002权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (1003, '用户详情', 100, NULL, 'sys:user:info', 'el-icon-s-custom', 2, 3, 1, 0, '1003权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (1004, '用户分页列表', 100, NULL, 'sys:user:page', 'el-icon-s-custom', 2, 3, 1, 0, '1004权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (1005, '用户修改密码', 100, NULL, 'sys:user:update:password', 'el-icon-s-custom', 2, 3, 1, 0, '1005权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (1006, '用户修改头像', 100, NULL, 'sys:user:update:head', 'el-icon-s-custom', 2, 3, 1, 0, '1006权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (1007, '用户重置密码', 100, NULL, 'sys:user:reset:password', 'el-icon-s-custom', 2, 3, 1, 0, '1007权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (2000, '角色新增', 200, NULL, 'sys:role:add', 'el-icon-s-custom', 2, 3, 1, 0, '2000权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (2001, '角色修改', 200, NULL, 'sys:role:update', 'el-icon-s-custom', 2, 3, 1, 0, '2001权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (2002, '角色删除', 200, NULL, 'sys:role:delete', 'el-icon-s-custom', 2, 3, 1, 0, '2002权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (2003, '角色详情', 200, NULL, 'sys:role:info', 'el-icon-s-custom', 2, 3, 1, 0, '2003权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (2004, '角色分页列表', 200, NULL, 'sys:role:page', 'el-icon-s-custom', 2, 3, 1, 0, '2004权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (2005, '角色列表', 200, NULL, 'sys:role:list', 'el-icon-s-custom', 2, 3, 1, 0, '2005权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (2006, '角色权限ID列表', 200, NULL, 'sys:permission:three-ids-by-role-id', 'el-icon-s-custom', 2, 3, 1, 0, '2006权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3000, '权限新增', 300, NULL, 'sys:permission:add', 'el-icon-s-custom', 2, 3, 1, 0, '3000权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3001, '权限修改', 300, NULL, 'sys:permission:update', 'el-icon-s-custom', 2, 3, 1, 0, '3001权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3002, '权限删除', 300, NULL, 'sys:permission:delete', 'el-icon-s-custom', 2, 3, 1, 0, '3002权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3003, '权限详情', 300, NULL, 'sys:permission:info', 'el-icon-s-custom', 2, 3, 1, 0, '3003权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3004, '权限分页列表', 300, NULL, 'sys:permission:page', 'el-icon-s-custom', 2, 3, 1, 0, '3004权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3005, '权限所有列表', 300, NULL, 'sys:permission:all:menu:list', 'el-icon-s-custom', 2, 3, 1, 0, '3005权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3006, '权限所有树形列表', 300, NULL, 'sys:permission:all:menu:tree', 'el-icon-s-custom', 2, 3, 1, 0, '3006权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3007, '权限用户列表', 300, NULL, 'sys:permission:menu:list', 'el-icon-s-custom', 2, 3, 1, 0, '3007权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3008, '权限用户树形列表', 300, NULL, 'sys:permission:menu:tree', 'el-icon-s-custom', 2, 3, 1, 0, '3008权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3009, '权限用户代码列表', 300, NULL, 'sys:permission:codes', 'el-icon-s-custom', 2, 3, 1, 0, '3009权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3010, '导航菜单', 300, NULL, 'sys:permission:nav-menu', 'el-icon-s-custom', 2, 3, 1, 0, '3010权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (3011, '角色权限修改', 300, NULL, 'sys:role-permission:update', 'el-icon-s-custom', 2, 3, 1, 0, '3011权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (4000, '部门新增', 400, NULL, 'sys:department:add', 'el-icon-s-custom', 2, 3, 1, 0, '4000权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (4001, '部门修改', 400, NULL, 'sys:department:update', 'el-icon-s-custom', 2, 3, 1, 0, '4001权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (4002, '部门删除', 400, NULL, 'sys:department:delete', 'el-icon-s-custom', 2, 3, 1, 0, '4002权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (4003, '部门详情', 400, NULL, 'sys:department:info', 'el-icon-s-custom', 2, 3, 1, 0, '4003权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (4004, '部门分页列表', 400, NULL, 'sys:department:page', 'el-icon-s-custom', 2, 3, 1, 0, '4004权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (4005, '部门列表', 400, NULL, 'sys:department:list', 'el-icon-s-custom', 2, 3, 1, 0, '4005权限备注', 1, '2019-10-26 11:18:40', '2020-03-09 00:50:13');
INSERT INTO `merchant_permission` VALUES (4006, '部门树形列表', 400, NULL, 'sys:department:all:tree', 'el-icon-s-custom', 2, 3, 1, 0, '4006权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (5001, '操作日志列表', 500, NULL, 'sys:operation:log:page', 'el-icon-s-custom', 2, 3, 1, 0, '5001权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (5002, '登录日志列表', 500, NULL, 'sys:login:log:page', 'el-icon-s-custom', 2, 3, 1, 0, '5002权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `merchant_permission` VALUES (6001, '测试Admin', 500, NULL, 'mer:admin', 'el-icon-s-custom', 2, 3, 1, 0, '5002权限备注', 0, '2019-10-26 11:18:40', NULL);
COMMIT;

-- ----------------------------
-- Table structure for merchant_role
-- ----------------------------
DROP TABLE IF EXISTS `merchant_role`;
CREATE TABLE `merchant_role` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '角色名称',
  `code` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '角色唯一编码',
  `type` int(11) DEFAULT NULL COMMENT '角色类型',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT '角色状态，0：禁用，1：启用',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT '版本',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `sys_role_name_uindex` (`name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='商家角色';

-- ----------------------------
-- Records of merchant_role
-- ----------------------------
BEGIN;
INSERT INTO `merchant_role` VALUES (1, '管理员', 'admin', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (2, 'test', 'test', NULL, 1, '测试人员拥有部分权限', 0, '2019-10-25 09:48:02', NULL);
INSERT INTO `merchant_role` VALUES (3, '管理员1', 'admin1', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (4, '管理员2', 'admin2', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (5, '管理员3', 'admin3', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (6, '管理员4', 'admin4', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (7, '管理员5', 'admin5', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (8, '管理员6', 'admin6', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (9, '管理员7', 'admin7', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (10, '管理员8', 'admin8', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (11, '管理员9', 'admin9', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (12, '管理员10', 'admin10', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (13, '管理员11', 'admin11', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (14, '管理员12', 'admin12', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (15, '管理员13', 'admin13', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (16, '管理员14', 'admin14', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (17, '管理员15', 'admin15', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (18, '管理员16', 'admin16', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (19, '管理员17', 'admin17', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (20, '管理员18', 'admin18', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (21, '管理员19', 'admin19', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (22, '管理员20', 'admin20', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `merchant_role` VALUES (23, '管理员21', 'admin21', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
COMMIT;

-- ----------------------------
-- Table structure for merchant_role_permission
-- ----------------------------
DROP TABLE IF EXISTS `merchant_role_permission`;
CREATE TABLE `merchant_role_permission` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `role_id` bigint(20) NOT NULL COMMENT '角色id',
  `permission_id` bigint(20) NOT NULL COMMENT '权限id',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT '状态，0：禁用，1：启用',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT '版本',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `permission_id` (`permission_id`) USING BTREE,
  KEY `role_id` (`role_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=346 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='商家角色权限关系';

-- ----------------------------
-- Records of merchant_role_permission
-- ----------------------------
BEGIN;
INSERT INTO `merchant_role_permission` VALUES (303, 1, 3008, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (304, 1, 1, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (305, 1, 3009, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (306, 1, 3010, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (307, 1, 3011, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (308, 1, 200, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (309, 1, 5001, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (310, 1, 5002, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (311, 1, 2000, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (312, 1, 400, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (313, 1, 2001, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (314, 1, 2002, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (315, 1, 2003, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (316, 1, 2004, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (317, 1, 2005, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (318, 1, 2006, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (319, 1, 4000, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (320, 1, 4001, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (321, 1, 4002, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (322, 1, 4003, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (323, 1, 100, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (324, 1, 4004, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (325, 1, 4005, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (326, 1, 4006, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (327, 1, 1000, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (328, 1, 1001, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (329, 1, 1002, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (330, 1, 1003, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (331, 1, 1004, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (332, 1, 300, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (333, 1, 1005, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (334, 1, 1006, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (335, 1, 1007, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (336, 1, 500, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (337, 1, 3000, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (338, 1, 3001, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (339, 1, 3002, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (340, 1, 3003, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (341, 1, 3004, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (342, 1, 3005, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (343, 1, 3006, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (344, 1, 3007, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `merchant_role_permission` VALUES (345, 1, 6001, 1, '测试', 0, '2020-09-28 10:48:28', NULL);
COMMIT;

-- ----------------------------
-- Table structure for merchant_user
-- ----------------------------
DROP TABLE IF EXISTS `merchant_user`;
CREATE TABLE `merchant_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `username` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '用户名',
  `nickname` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '昵称',
  `password` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '密码',
  `salt` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '盐值',
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '手机号码',
  `phone_area` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '手机区号',
  `gender` int(11) DEFAULT '1' COMMENT '性别，0：女，1：男，默认1',
  `head` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '头像',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT '状态，0：禁用，1：启用，2：锁定',
  `department_id` bigint(20) DEFAULT NULL COMMENT '部门id',
  `role_id` bigint(20) DEFAULT NULL COMMENT '角色id',
  `deleted` int(11) NOT NULL DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT '版本',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `sys_user_username_uindex` (`username`) USING BTREE,
  KEY `department_id` (`department_id`) USING BTREE,
  KEY `role_id` (`role_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='商家';

-- ----------------------------
-- Records of merchant_user
-- ----------------------------
BEGIN;
INSERT INTO `merchant_user` VALUES (1, 'adminMer', '管理员', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889900', '855', 1, '', '', 1, NULL, 1, 0, 1, '2020-02-26 00:00:00', '2019-10-27 23:32:29');
INSERT INTO `merchant_user` VALUES (2, 'test', '测试人员1', '34783fb724b259beb71a1279f7cd93bdcfd92a273d566f926419a37825c500df', '087c2e9857f35f1e243367f3b89b81c1', '15888889901', '855', 1, '', '', 1, NULL, 1, 0, 1, '2020-02-26 00:00:01', '2020-02-15 19:31:50');
INSERT INTO `merchant_user` VALUES (100, 'dddd', 'ddddd', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', 'aa98a65fa53d198f38d8e3a63f3f5a65', 'ddddddddddd', '855', 1, '', '', 1, NULL, 1, 0, 1, '2020-02-26 14:06:53', '2020-02-27 14:06:52');
INSERT INTO `merchant_user` VALUES (101, 'adminx', '111111', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '1faf81180b4a4a78c48d7c31479a0622', '11111111111', '855', 1, '', '', 1, NULL, 1, 1, 6, '2020-02-26 14:19:57', '2020-03-02 17:33:48');
COMMIT;

-- ----------------------------
-- Table structure for plain_type
-- ----------------------------
DROP TABLE IF EXISTS `plain_type`;
CREATE TABLE `plain_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `series_type` int(2) NOT NULL COMMENT '系列类型',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '飞机名称',
  `img_url` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '飞机图片地址',
  `status` int(2) NOT NULL COMMENT '状态，0-正常，1-禁用，99-删除',
  `create_time` bigint(20) NOT NULL COMMENT '创建时间（时间戳）',
  `update_time` bigint(20) DEFAULT NULL COMMENT '更新时间（时间戳）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='飞机型号表';

-- ----------------------------
-- Records of plain_type
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for stroke
-- ----------------------------
DROP TABLE IF EXISTS `stroke`;
CREATE TABLE `stroke` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `city_outset_id` bigint(20) NOT NULL COMMENT '出发城市id',
  `city_outset_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '出发城市名称',
  `city_arrive_id` bigint(20) NOT NULL COMMENT '到达城市id',
  `city_arrive_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '到达城市名称',
  `people_mun` int(5) DEFAULT NULL COMMENT '人数',
  `plain_type_id` bigint(20) DEFAULT NULL COMMENT '飞机型号ID',
  `outset_time` bigint(20) NOT NULL COMMENT '出发时间',
  `return_time` bigint(20) DEFAULT NULL COMMENT '返程时间',
  `type` int(1) NOT NULL COMMENT '行程类型，0-单程，1-往返行程，2-货运，3-医疗',
  `status` int(2) NOT NULL DEFAULT '0' COMMENT '状态，0-审核中，1-进行中，2-已完成，99-取消',
  `create_time` bigint(20) NOT NULL COMMENT '创建时间',
  `update_time` bigint(20) DEFAULT NULL COMMENT '更新时间',
  `goods_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '货物名称',
  `goods_size` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '货物体积（长*宽*高） 单位：CM，例如：100*102*120',
  `goods_weight` double(7,2) DEFAULT NULL COMMENT '货物重量，单位：吨',
  `disease_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '病人疾病名称',
  `medical_certificate_url` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '病人病情诊断书',
  `instruments` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '配备器械（格式：1,2,3）逗号分隔',
  `medical_persons` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '医护人员，0-医生，1-护士，2-护工（格式：0,1,2）逗号分隔',
  `remarks` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `money` bigint(20) NOT NULL DEFAULT '0' COMMENT '价格，单位：分',
  `user_id` bigint(20) NOT NULL COMMENT '用户ID',
  `choose_plain_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '用户选择机型',
  `mc_id` bigint(20) NOT NULL COMMENT '商家id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='行程表';

-- ----------------------------
-- Records of stroke
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for stroke_discount
-- ----------------------------
DROP TABLE IF EXISTS `stroke_discount`;
CREATE TABLE `stroke_discount` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `city_outset_id` bigint(20) NOT NULL COMMENT '出发城市id',
  `city_outset_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '出发城市名称',
  `city_arrive_id` bigint(20) NOT NULL COMMENT '到达城市id',
  `city_arrive_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '到达城市名称',
  `seat_mun` int(5) NOT NULL COMMENT '座位数',
  `plain_type_id` bigint(20) NOT NULL COMMENT '飞机型号ID',
  `outset_time` datetime NOT NULL COMMENT '出发时间',
  `return_time` datetime DEFAULT NULL COMMENT '返程时间',
  `status` int(2) NOT NULL COMMENT '状态，0-正常，1-完成，99-删除',
  `create_time` bigint(20) NOT NULL COMMENT '创建时间',
  `update_time` bigint(20) DEFAULT NULL COMMENT '更新时间',
  `remarks` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `money` bigint(20) NOT NULL DEFAULT '0' COMMENT '价格，单位：分',
  `mcu_id` bigint(20) NOT NULL COMMENT '商家ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='优惠行程表';

-- ----------------------------
-- Records of stroke_discount
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for sys_department
-- ----------------------------
DROP TABLE IF EXISTS `sys_department`;
CREATE TABLE `sys_department` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '部门名称',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父id',
  `level` int(11) DEFAULT NULL COMMENT '部门层级',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT '状态，0：禁用，1：启用',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT '版本',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `sys_department_name_uindex` (`name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=206 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='部门';

-- ----------------------------
-- Records of sys_department
-- ----------------------------
BEGIN;
INSERT INTO `sys_department` VALUES (1, '技术部', NULL, 1, 1, 359544077, 'fe8c9cbac0c54395ac411335a31f4888', 15, '2019-10-25 09:46:49', '2019-11-13 19:56:07');
INSERT INTO `sys_department` VALUES (2, '研发部', NULL, 1, 1, 0, NULL, 0, '2019-11-01 20:45:43', NULL);
INSERT INTO `sys_department` VALUES (20, '前端开发部', 2, 2, 1, 0, NULL, 0, '2019-11-01 20:48:38', NULL);
INSERT INTO `sys_department` VALUES (21, '后台开发部', 2, 2, 1, 0, NULL, 0, '2019-11-01 20:48:38', NULL);
INSERT INTO `sys_department` VALUES (22, '测试部', 2, 2, 1, 0, NULL, 0, '2019-11-01 20:48:38', NULL);
INSERT INTO `sys_department` VALUES (201, '前端一组', 20, 3, 1, 0, NULL, 0, '2019-11-01 20:48:38', NULL);
INSERT INTO `sys_department` VALUES (202, '前端二组', 20, 3, 1, 0, NULL, 0, '2019-11-01 20:48:38', NULL);
INSERT INTO `sys_department` VALUES (203, '后台一组', 21, 3, 1, 0, NULL, 0, '2019-11-01 20:48:38', NULL);
INSERT INTO `sys_department` VALUES (204, '后台二组', 21, 3, 1, 0, NULL, 0, '2019-11-01 20:48:38', NULL);
INSERT INTO `sys_department` VALUES (205, '测试一组', 22, 3, 1, 0, NULL, 0, '2019-11-01 20:48:38', NULL);
COMMIT;

-- ----------------------------
-- Table structure for sys_login_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_login_log`;
CREATE TABLE `sys_login_log` (
  `id` bigint(18) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `request_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '请求ID',
  `username` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '用户名称',
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'IP',
  `area` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '区域',
  `operator` varchar(6) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '运营商',
  `token` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'tokenMd5值',
  `type` int(11) DEFAULT NULL COMMENT '1:登录，2：登出',
  `success` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否成功 true:成功/false:失败',
  `code` int(11) DEFAULT NULL COMMENT '响应码',
  `exception_message` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '失败消息记录',
  `user_agent` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '浏览器名称',
  `browser_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '浏览器名称',
  `browser_version` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '浏览器版本',
  `engine_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '浏览器引擎名称',
  `engine_version` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '浏览器引擎版本',
  `os_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '系统名称',
  `platform_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '平台名称',
  `mobile` tinyint(1) DEFAULT NULL COMMENT '是否是手机,0:否,1:是',
  `device_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '移动端设备名称',
  `device_model` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '移动端设备型号',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统登录日志';

-- ----------------------------
-- Records of sys_login_log
-- ----------------------------
BEGIN;
INSERT INTO `sys_login_log` VALUES (1, '1242813712335691777', 'admin', '127.0.0.1', '本机地址', NULL, 'c87aaffa35dadafb066cf18679eab36e', 1, 1, 200, NULL, 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36', 'Chrome', '80.0.3987.149', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-03-25 22:01:11', NULL);
INSERT INTO `sys_login_log` VALUES (2, '1242813887884091393', 'admin', '127.0.0.1', '本机地址', NULL, 'c87aaffa35dadafb066cf18679eab36e', 2, 1, 200, NULL, 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36', 'Chrome', '80.0.3987.149', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-03-25 22:01:48', NULL);
INSERT INTO `sys_login_log` VALUES (3, '1242814069371625474', 'admin', '127.0.0.1', '本机地址', NULL, NULL, 1, 0, NULL, '用户名或密码错误', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36', 'Chrome', '80.0.3987.149', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-03-25 22:02:25', NULL);
INSERT INTO `sys_login_log` VALUES (4, '1242814192096960513', NULL, '127.0.0.1', '本机地址', NULL, NULL, 2, 0, NULL, 'token不能为空', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36', 'Chrome', '80.0.3987.149', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-03-25 22:02:54', NULL);
COMMIT;

-- ----------------------------
-- Table structure for sys_operation_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_operation_log`;
CREATE TABLE `sys_operation_log` (
  `id` bigint(18) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `request_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '请求ID',
  `user_id` bigint(18) DEFAULT NULL COMMENT '用户ID',
  `user_name` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '用户名称',
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '日志名称',
  `ip` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'IP',
  `area` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '区域',
  `operator` varchar(6) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '运营商',
  `path` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '全路径',
  `module` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '模块名称',
  `class_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '类名',
  `method_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '方法名称',
  `request_method` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '请求方式，GET/POST',
  `content_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '内容类型',
  `request_body` tinyint(1) DEFAULT NULL COMMENT '是否是JSON请求映射参数',
  `param` text COLLATE utf8mb4_unicode_ci COMMENT '请求参数',
  `token` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'tokenMd5值',
  `type` int(11) DEFAULT NULL COMMENT '0:其它,1:新增,2:修改,3:删除,4:详情查询,5:所有列表,6:分页列表,7:其它查询,8:上传文件',
  `success` tinyint(1) DEFAULT NULL COMMENT '0:失败,1:成功',
  `code` int(11) DEFAULT NULL COMMENT '响应结果状态码',
  `message` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '响应结果消息',
  `exception_name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '异常类名称',
  `exception_message` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '异常信息',
  `browser_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '浏览器名称',
  `browser_version` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '浏览器版本',
  `engine_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '浏览器引擎名称',
  `engine_version` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '浏览器引擎版本',
  `os_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '系统名称',
  `platform_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '平台名称',
  `mobile` tinyint(1) DEFAULT NULL COMMENT '是否是手机,0:否,1:是',
  `device_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '移动端设备名称',
  `device_model` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '移动端设备型号',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=229 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统操作日志';

-- ----------------------------
-- Records of sys_operation_log
-- ----------------------------
BEGIN;
INSERT INTO `sys_operation_log` VALUES (1, '1242805276474634241', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/hello/world', NULL, 'io.geekidea.springbootplus.system.controller.HelloWorldController', 'helloWorld', 'GET', NULL, 0, NULL, NULL, 0, 1, 200, '操作成功', NULL, NULL, 'Chrome', '80.0.3987.149', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-03-25 21:27:22', NULL);
INSERT INTO `sys_operation_log` VALUES (2, '1242820418688049153', NULL, NULL, 'FooBar分页列表', '127.0.0.1', '本机地址', NULL, '/api/fooBar/getPageList', 'foobar', 'com.example.foobar.controller.FooBarController', 'getFooBarPageList', 'POST', 'application/json', 1, '{\"pageIndex\":1,\"pageSize\":10}', NULL, 7, 1, 200, '操作成功', NULL, NULL, 'Chrome', '80.0.3987.149', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-03-25 22:27:33', NULL);
INSERT INTO `sys_operation_log` VALUES (3, '1308689850219634690', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-23 16:49:09', NULL);
INSERT INTO `sys_operation_log` VALUES (4, '1308690605953622018', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-23 16:52:09', NULL);
INSERT INTO `sys_operation_log` VALUES (5, '1308690612433821698', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-23 16:52:11', NULL);
INSERT INTO `sys_operation_log` VALUES (6, '1308690618981130241', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-23 16:52:12', NULL);
INSERT INTO `sys_operation_log` VALUES (7, '1308690623922020354', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-23 16:52:14', NULL);
INSERT INTO `sys_operation_log` VALUES (8, '1308690666318045185', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-23 16:52:24', NULL);
INSERT INTO `sys_operation_log` VALUES (9, '1308691181487562754', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-23 16:54:27', NULL);
INSERT INTO `sys_operation_log` VALUES (10, '1308691225674555394', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-23 16:54:37', NULL);
INSERT INTO `sys_operation_log` VALUES (11, '1309323233496952834', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 10:46:00', NULL);
INSERT INTO `sys_operation_log` VALUES (12, '1309336923415875585', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 11:40:23', NULL);
INSERT INTO `sys_operation_log` VALUES (13, '1309340953856704514', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '522851b7b4bdee780c8ed3c582946a47', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 11:56:24', NULL);
INSERT INTO `sys_operation_log` VALUES (14, '1309341289782706177', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 11:57:44', NULL);
INSERT INTO `sys_operation_log` VALUES (15, '1309342596543287297', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, 'aa39c8aeb781c5953c9877227b249314', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 12:02:56', NULL);
INSERT INTO `sys_operation_log` VALUES (16, '1309345484850196481', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, 'aa39c8aeb781c5953c9877227b249314', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 12:14:25', NULL);
INSERT INTO `sys_operation_log` VALUES (17, '1309345499630923778', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, 'aa39c8aeb781c5953c9877227b249314', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 12:14:28', NULL);
INSERT INTO `sys_operation_log` VALUES (18, '1309390815088365570', NULL, NULL, '获取所有菜单列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getAllMenuList', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getAllMenuList', 'POST', NULL, 0, NULL, '41364c87b47b4afcc48cb6029f069fe7', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:14:32', NULL);
INSERT INTO `sys_operation_log` VALUES (19, '1309392254120501250', NULL, NULL, '获取所有菜单列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getAllMenuList', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getAllMenuList', 'POST', NULL, 0, NULL, '41364c87b47b4afcc48cb6029f069fe7', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:20:16', NULL);
INSERT INTO `sys_operation_log` VALUES (20, '1309392342955859970', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '63cfadcf0001df436d9baa53fe4dbf5d', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:20:36', NULL);
INSERT INTO `sys_operation_log` VALUES (21, '1309393422196416514', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, 'b9312c2225b282c2177181b73862a1de', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:24:54', NULL);
INSERT INTO `sys_operation_log` VALUES (22, '1309393749482151938', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, 'b9312c2225b282c2177181b73862a1de', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:26:12', NULL);
INSERT INTO `sys_operation_log` VALUES (23, '1309393774396317698', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:26:18', NULL);
INSERT INTO `sys_operation_log` VALUES (24, '1309393786954063873', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, 'b9312c2225b282c2177181b73862a1de', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:26:21', NULL);
INSERT INTO `sys_operation_log` VALUES (25, '1309393792868032514', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, 'b9312c2225b282c2177181b73862a1de', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:26:22', NULL);
INSERT INTO `sys_operation_log` VALUES (26, '1309393815475331074', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/app/world', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'helloWorld', 'GET', NULL, 0, NULL, NULL, 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:26:28', NULL);
INSERT INTO `sys_operation_log` VALUES (27, '1309393827995328514', NULL, NULL, 'helloWorld', '127.0.0.1', '本机地址', NULL, '/api/app/world', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'helloWorld', 'GET', NULL, 0, NULL, 'b9312c2225b282c2177181b73862a1de', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:26:31', NULL);
INSERT INTO `sys_operation_log` VALUES (28, '1309394828739485697', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, '126bedef387c8fbf8a7af1df8d893b63', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:30:29', NULL);
INSERT INTO `sys_operation_log` VALUES (29, '1309394837140676609', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, 'ca61d2b066103e97620a10c5aae92fc2', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 15:30:31', NULL);
INSERT INTO `sys_operation_log` VALUES (30, '1309410923814973441', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '0bba16a97f575098ba342a0c65a05a50', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:34:26', NULL);
INSERT INTO `sys_operation_log` VALUES (31, '1309410939984015362', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '84645a54f5a0cfd4dc305e74345be8ea', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:34:30', NULL);
INSERT INTO `sys_operation_log` VALUES (32, '1309410953426759681', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '9f447da18e6a8aaa2a6b1237caa8ff92', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:34:33', NULL);
INSERT INTO `sys_operation_log` VALUES (33, '1309410978781327361', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '6432b54b01c701b04a8755f39d78759e', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:34:40', NULL);
INSERT INTO `sys_operation_log` VALUES (34, '1309411039967834113', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, 'f7c0e071db137f5ae65382041c7cef4b', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:34:54', NULL);
INSERT INTO `sys_operation_log` VALUES (35, '1309411448853753858', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '4f390a0f073175d25d71691e8ef412ff', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:36:32', NULL);
INSERT INTO `sys_operation_log` VALUES (36, '1309411453752700930', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '4f390a0f073175d25d71691e8ef412ff', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:36:33', NULL);
INSERT INTO `sys_operation_log` VALUES (37, '1309411587928485889', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '4f390a0f073175d25d71691e8ef412ff', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:37:05', NULL);
INSERT INTO `sys_operation_log` VALUES (38, '1309411773807456258', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, '0bba16a97f575098ba342a0c65a05a50', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:37:49', NULL);
INSERT INTO `sys_operation_log` VALUES (39, '1309413036108402690', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '717f483b8046ac08ba40da566fd37058', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:42:50', NULL);
INSERT INTO `sys_operation_log` VALUES (40, '1309413048934584322', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '2a9235e6628a0bce2ecb686f385a70cc', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:42:53', NULL);
INSERT INTO `sys_operation_log` VALUES (41, '1309413065984430082', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '202cb962ac59075b964b07152d234b70', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:42:57', NULL);
INSERT INTO `sys_operation_log` VALUES (42, '1309413483040739329', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '717f483b8046ac08ba40da566fd37058', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:44:37', NULL);
INSERT INTO `sys_operation_log` VALUES (43, '1309413498614190081', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '11ddbaf3386aea1f2974eee984542152', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:44:40', NULL);
INSERT INTO `sys_operation_log` VALUES (44, '1309413924256473090', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '2aa746cb52d5358a72fa02b8471b5d97', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:46:22', NULL);
INSERT INTO `sys_operation_log` VALUES (45, '1309413935258132482', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, 'ffe45ba74485713d0c947d951b6f38b3', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:46:24', NULL);
INSERT INTO `sys_operation_log` VALUES (46, '1309414000668303361', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '8ac4646097a60609a5c5f3820c078990', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:46:40', NULL);
INSERT INTO `sys_operation_log` VALUES (47, '1309414204016549890', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '8ac4646097a60609a5c5f3820c078990', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:47:28', NULL);
INSERT INTO `sys_operation_log` VALUES (48, '1309414559483719682', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '3485aad32c204a0c1601b1b2b8136539', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:48:53', NULL);
INSERT INTO `sys_operation_log` VALUES (49, '1309414573744353282', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '202cb962ac59075b964b07152d234b70', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:48:57', NULL);
INSERT INTO `sys_operation_log` VALUES (50, '1309414672818008065', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '202cb962ac59075b964b07152d234b70', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:49:20', NULL);
INSERT INTO `sys_operation_log` VALUES (51, '1309414765864448001', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, '34ac48ab4c336593befd59740ae9fe88', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:49:42', NULL);
INSERT INTO `sys_operation_log` VALUES (52, '1309414778522857473', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, 'b3af409bb8423187c75e6c7f5b683908', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:49:45', NULL);
INSERT INTO `sys_operation_log` VALUES (53, '1309414804527542273', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, '6ac181bab35c1d1be2ee055c4e73d2d4', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:49:52', NULL);
INSERT INTO `sys_operation_log` VALUES (54, '1309416338103500801', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, '1332f7a2650d80a2da93426b3c19179d', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:55:57', NULL);
INSERT INTO `sys_operation_log` VALUES (55, '1309416358269714433', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, '446269413ee2d2fd2a4f9a463c3c0e73', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:56:02', NULL);
INSERT INTO `sys_operation_log` VALUES (56, '1309416413080879106', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, '446269413ee2d2fd2a4f9a463c3c0e73', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:56:15', NULL);
INSERT INTO `sys_operation_log` VALUES (57, '1309416520278900737', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, '446269413ee2d2fd2a4f9a463c3c0e73', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:56:41', NULL);
INSERT INTO `sys_operation_log` VALUES (58, '1309416664764284929', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, '064118ea1cc54a6d342bd03796661df1', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:57:15', NULL);
INSERT INTO `sys_operation_log` VALUES (59, '1309416740156899330', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, '064118ea1cc54a6d342bd03796661df1', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 16:57:33', NULL);
INSERT INTO `sys_operation_log` VALUES (60, '1309418060091756545', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, '3f7fe0f3801726475e151710f7775043', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:02:48', NULL);
INSERT INTO `sys_operation_log` VALUES (61, '1309418184142491649', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '3f7fe0f3801726475e151710f7775043', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:03:17', NULL);
INSERT INTO `sys_operation_log` VALUES (62, '1309418617695113218', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '10825fb00bccd8a6371f3648569b1595', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:05:01', NULL);
INSERT INTO `sys_operation_log` VALUES (63, '1309418719931273217', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, '10825fb00bccd8a6371f3648569b1595', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:05:25', NULL);
INSERT INTO `sys_operation_log` VALUES (64, '1309418812541505537', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, '8a131735b7aeb825dfe314ce91f5c123', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:05:47', NULL);
INSERT INTO `sys_operation_log` VALUES (65, '1309418816681283586', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, '8a131735b7aeb825dfe314ce91f5c123', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:05:48', NULL);
INSERT INTO `sys_operation_log` VALUES (66, '1309418829213863937', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, 'cec950426c81a9bc6db5c43c4b802463', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:05:51', NULL);
INSERT INTO `sys_operation_log` VALUES (67, '1309418832590278657', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, 'cec950426c81a9bc6db5c43c4b802463', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:05:52', NULL);
INSERT INTO `sys_operation_log` VALUES (68, '1309418843067650049', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, '144f8cdbc48ba3d379f39ec20cbe3122', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:05:54', NULL);
INSERT INTO `sys_operation_log` VALUES (69, '1309418856212598786', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, 'f7e0ef389ac6133c88aedbd66b44a4e1', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:05:58', NULL);
INSERT INTO `sys_operation_log` VALUES (70, '1309418860851499010', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, 'f7e0ef389ac6133c88aedbd66b44a4e1', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:05:59', NULL);
INSERT INTO `sys_operation_log` VALUES (71, '1309418866396368897', NULL, NULL, 'noRole', '127.0.0.1', '本机地址', NULL, '/api/app/noRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'noRole', 'GET', NULL, 0, NULL, 'f7e0ef389ac6133c88aedbd66b44a4e1', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:06:00', NULL);
INSERT INTO `sys_operation_log` VALUES (72, '1309418905806049282', NULL, NULL, 'needRole', '127.0.0.1', '本机地址', NULL, '/api/app/needRole', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRole', 'GET', NULL, 0, NULL, '10825fb00bccd8a6371f3648569b1595', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.102', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-25 17:06:09', NULL);
INSERT INTO `sys_operation_log` VALUES (73, '1310412300573855745', NULL, NULL, 'needRoleAdmin', '127.0.0.1', '本机地址', NULL, '/api/merchant/needRoleAdmin', NULL, 'com.jumeirah.api.merchant.controller.MerchantHelloWorldController', 'needRoleAdmin', 'GET', NULL, 0, NULL, '971eeb0323583c798d39a7f1da08f852', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 10:53:33', NULL);
INSERT INTO `sys_operation_log` VALUES (74, '1310417185063161857', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/sys/getSysUserInfo', 'system', 'com.jumeirah.api.system.controller.LoginController', 'getSysUser', 'GET', NULL, 0, NULL, '83ac75dfdd28a198ccb3d78475325009', NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-28 11:12:58', NULL);
INSERT INTO `sys_operation_log` VALUES (75, '1310417228746838019', NULL, NULL, '获取所有部门的树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysDepartment/getDepartmentTree', 'system', 'com.jumeirah.api.system.controller.SysDepartmentController', 'getDepartmentTree', 'POST', NULL, 0, NULL, '83ac75dfdd28a198ccb3d78475325009', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:13:08', NULL);
INSERT INTO `sys_operation_log` VALUES (76, '1310417228746838018', NULL, NULL, '系统角色列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getRoleList', 'POST', NULL, 0, NULL, '83ac75dfdd28a198ccb3d78475325009', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:13:08', NULL);
INSERT INTO `sys_operation_log` VALUES (77, '1310417228809752578', NULL, NULL, '系统用户分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysUser/getPageList', 'system', 'com.jumeirah.api.system.controller.SysUserController', 'getSysUserPageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '83ac75dfdd28a198ccb3d78475325009', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:13:08', NULL);
INSERT INTO `sys_operation_log` VALUES (78, '1310417248464261122', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '83ac75dfdd28a198ccb3d78475325009', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:13:13', NULL);
INSERT INTO `sys_operation_log` VALUES (79, '1310417258140520450', NULL, NULL, '获取获取菜单树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getAllMenuTree', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getAllMenuTree', 'POST', NULL, 0, NULL, '83ac75dfdd28a198ccb3d78475325009', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:13:15', NULL);
INSERT INTO `sys_operation_log` VALUES (80, '1310417265753182209', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '83ac75dfdd28a198ccb3d78475325009', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:13:17', NULL);
INSERT INTO `sys_operation_log` VALUES (81, '1310417577503215617', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/sys/getSysUserInfo', 'system', 'com.jumeirah.api.system.controller.LoginController', 'getSysUser', 'GET', NULL, 0, NULL, '83ac75dfdd28a198ccb3d78475325009', NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-28 11:14:31', NULL);
INSERT INTO `sys_operation_log` VALUES (82, '1310417630062039042', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/sys/getSysUserInfo', 'system', 'com.jumeirah.api.system.controller.LoginController', 'getSysUser', 'GET', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-28 11:14:44', NULL);
INSERT INTO `sys_operation_log` VALUES (83, '1310417646285606914', NULL, NULL, '获取获取菜单树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getAllMenuTree', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getAllMenuTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:14:48', NULL);
INSERT INTO `sys_operation_log` VALUES (84, '1310417919364157442', NULL, NULL, '系统角色列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getRoleList', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:15:53', NULL);
INSERT INTO `sys_operation_log` VALUES (85, '1310417919364157441', NULL, NULL, '获取所有部门的树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysDepartment/getDepartmentTree', 'system', 'com.jumeirah.api.system.controller.SysDepartmentController', 'getDepartmentTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:15:53', NULL);
INSERT INTO `sys_operation_log` VALUES (86, '1310417919364157443', NULL, NULL, '系统用户分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysUser/getPageList', 'system', 'com.jumeirah.api.system.controller.SysUserController', 'getSysUserPageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:15:53', NULL);
INSERT INTO `sys_operation_log` VALUES (87, '1310417942734819330', NULL, NULL, '获取获取菜单树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getAllMenuTree', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getAllMenuTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:15:59', NULL);
INSERT INTO `sys_operation_log` VALUES (88, '1310417947419856897', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:16:00', NULL);
INSERT INTO `sys_operation_log` VALUES (89, '1310417969511256066', NULL, NULL, '获取所有部门的树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysDepartment/getDepartmentTree', 'system', 'com.jumeirah.api.system.controller.SysDepartmentController', 'getDepartmentTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:16:05', NULL);
INSERT INTO `sys_operation_log` VALUES (90, '1310417969528033281', NULL, NULL, '系统角色列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getRoleList', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:16:05', NULL);
INSERT INTO `sys_operation_log` VALUES (91, '1310417969528033282', NULL, NULL, '系统用户分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysUser/getPageList', 'system', 'com.jumeirah.api.system.controller.SysUserController', 'getSysUserPageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:16:05', NULL);
INSERT INTO `sys_operation_log` VALUES (92, '1310417987525791746', NULL, NULL, '获取获取菜单树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getAllMenuTree', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getAllMenuTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:16:09', NULL);
INSERT INTO `sys_operation_log` VALUES (93, '1310418026679619585', NULL, NULL, '获取所有导航菜单(一级/二级菜单)', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getNavMenuTree', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getNavMenuTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:16:19', NULL);
INSERT INTO `sys_operation_log` VALUES (94, '1310418096057602050', NULL, NULL, '系统权限详情', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/info/200', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getSysPermission', 'GET', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:16:35', NULL);
INSERT INTO `sys_operation_log` VALUES (95, '1310418096045019138', NULL, NULL, '获取所有导航菜单(一级/二级菜单)', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getNavMenuTree', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getNavMenuTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:16:35', NULL);
INSERT INTO `sys_operation_log` VALUES (96, '1310418386601234434', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:17:44', NULL);
INSERT INTO `sys_operation_log` VALUES (97, '1310418400136253441', NULL, NULL, '系统角色列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getRoleList', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:17:48', NULL);
INSERT INTO `sys_operation_log` VALUES (98, '1310418400136253442', NULL, NULL, '获取所有部门的树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysDepartment/getDepartmentTree', 'system', 'com.jumeirah.api.system.controller.SysDepartmentController', 'getDepartmentTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:17:48', NULL);
INSERT INTO `sys_operation_log` VALUES (99, '1310418400136253443', NULL, NULL, '系统用户分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysUser/getPageList', 'system', 'com.jumeirah.api.system.controller.SysUserController', 'getSysUserPageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:17:48', NULL);
INSERT INTO `sys_operation_log` VALUES (100, '1310418622342090753', NULL, NULL, '获取获取菜单树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getAllMenuTree', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getAllMenuTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:18:41', NULL);
INSERT INTO `sys_operation_log` VALUES (101, '1310418712146333698', NULL, NULL, '获取所有部门的树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysDepartment/getDepartmentTree', 'system', 'com.jumeirah.api.system.controller.SysDepartmentController', 'getDepartmentTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:19:02', NULL);
INSERT INTO `sys_operation_log` VALUES (102, '1310418712146333699', NULL, NULL, '系统角色列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getRoleList', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:19:02', NULL);
INSERT INTO `sys_operation_log` VALUES (103, '1310418712146333700', NULL, NULL, '系统用户分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysUser/getPageList', 'system', 'com.jumeirah.api.system.controller.SysUserController', 'getSysUserPageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:19:02', NULL);
INSERT INTO `sys_operation_log` VALUES (104, '1310418737052110850', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:19:08', NULL);
INSERT INTO `sys_operation_log` VALUES (105, '1310419237411606530', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:07', NULL);
INSERT INTO `sys_operation_log` VALUES (106, '1310419240985153538', NULL, NULL, '系统角色列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getRoleList', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:08', NULL);
INSERT INTO `sys_operation_log` VALUES (107, '1310419240985153539', NULL, NULL, '获取所有部门的树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysDepartment/getDepartmentTree', 'system', 'com.jumeirah.api.system.controller.SysDepartmentController', 'getDepartmentTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:08', NULL);
INSERT INTO `sys_operation_log` VALUES (108, '1310419240985153540', NULL, NULL, '系统用户分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysUser/getPageList', 'system', 'com.jumeirah.api.system.controller.SysUserController', 'getSysUserPageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:08', NULL);
INSERT INTO `sys_operation_log` VALUES (109, '1310419241970814978', NULL, NULL, '获取获取菜单树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getAllMenuTree', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getAllMenuTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:08', NULL);
INSERT INTO `sys_operation_log` VALUES (110, '1310419254960574466', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:12', NULL);
INSERT INTO `sys_operation_log` VALUES (111, '1310419279321092098', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":3,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:17', NULL);
INSERT INTO `sys_operation_log` VALUES (112, '1310419289249009666', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":2,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:20', NULL);
INSERT INTO `sys_operation_log` VALUES (113, '1310419325882060803', NULL, NULL, '系统角色列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getRoleList', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:28', NULL);
INSERT INTO `sys_operation_log` VALUES (114, '1310419325882060802', NULL, NULL, '获取所有部门的树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysDepartment/getDepartmentTree', 'system', 'com.jumeirah.api.system.controller.SysDepartmentController', 'getDepartmentTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:28', NULL);
INSERT INTO `sys_operation_log` VALUES (115, '1310419325886255105', NULL, NULL, '系统用户分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysUser/getPageList', 'system', 'com.jumeirah.api.system.controller.SysUserController', 'getSysUserPageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:29', NULL);
INSERT INTO `sys_operation_log` VALUES (116, '1310419338859237377', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:32', NULL);
INSERT INTO `sys_operation_log` VALUES (117, '1310419343556857857', NULL, NULL, '获取获取菜单树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getAllMenuTree', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getAllMenuTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:33', NULL);
INSERT INTO `sys_operation_log` VALUES (118, '1310419344097923075', NULL, NULL, '系统角色列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getRoleList', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:33', NULL);
INSERT INTO `sys_operation_log` VALUES (119, '1310419344097923074', NULL, NULL, '获取所有部门的树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysDepartment/getDepartmentTree', 'system', 'com.jumeirah.api.system.controller.SysDepartmentController', 'getDepartmentTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:33', NULL);
INSERT INTO `sys_operation_log` VALUES (120, '1310419344097923076', NULL, NULL, '系统用户分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysUser/getPageList', 'system', 'com.jumeirah.api.system.controller.SysUserController', 'getSysUserPageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:33', NULL);
INSERT INTO `sys_operation_log` VALUES (121, '1310419355414155266', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:21:35', NULL);
INSERT INTO `sys_operation_log` VALUES (122, '1310422582390018050', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/sys/getSysUserInfo', 'system', 'com.jumeirah.api.system.controller.LoginController', 'getSysUser', 'GET', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-28 11:34:25', NULL);
INSERT INTO `sys_operation_log` VALUES (123, '1310422585892261889', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:34:26', NULL);
INSERT INTO `sys_operation_log` VALUES (124, '1310423196993966082', NULL, NULL, '系统角色列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getRoleList', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:36:51', NULL);
INSERT INTO `sys_operation_log` VALUES (125, '1310423196993966081', NULL, NULL, '获取所有部门的树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysDepartment/getDepartmentTree', 'system', 'com.jumeirah.api.system.controller.SysDepartmentController', 'getDepartmentTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:36:51', NULL);
INSERT INTO `sys_operation_log` VALUES (126, '1310423196998160386', NULL, NULL, '系统用户分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysUser/getPageList', 'system', 'com.jumeirah.api.system.controller.SysUserController', 'getSysUserPageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:36:51', NULL);
INSERT INTO `sys_operation_log` VALUES (127, '1310423216161935362', NULL, NULL, '获取获取菜单树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysPermission/getAllMenuTree', 'system', 'com.jumeirah.api.system.controller.SysPermissionController', 'getAllMenuTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:36:56', NULL);
INSERT INTO `sys_operation_log` VALUES (128, '1310423224575709185', NULL, NULL, '系统角色分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getPageList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getSysRolePageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:36:58', NULL);
INSERT INTO `sys_operation_log` VALUES (129, '1310423239327076354', NULL, NULL, '获取所有部门的树形列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysDepartment/getDepartmentTree', 'system', 'com.jumeirah.api.system.controller.SysDepartmentController', 'getDepartmentTree', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 8, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:37:01', NULL);
INSERT INTO `sys_operation_log` VALUES (130, '1310423239327076355', NULL, NULL, '系统角色列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysRole/getList', 'system', 'com.jumeirah.api.system.controller.SysRoleController', 'getRoleList', 'POST', NULL, 0, NULL, '64d672864ed73c8a3d61d9fb7164338a', 6, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:37:01', NULL);
INSERT INTO `sys_operation_log` VALUES (131, '1310423239327076356', NULL, NULL, '系统用户分页列表', '127.0.0.1', '本机地址', NULL, '/api/sys/sysUser/getPageList', 'system', 'com.jumeirah.api.system.controller.SysUserController', 'getSysUserPageList', 'POST', 'application/json;charset=UTF-8', 1, '{\"pageIndex\":1,\"pageSize\":10,\"pageSorts\":[{\"column\":\"id\",\"asc\":false}]}', '64d672864ed73c8a3d61d9fb7164338a', 7, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 11:37:01', NULL);
INSERT INTO `sys_operation_log` VALUES (132, '1310434998213455873', NULL, NULL, '获取验证码-注册', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'getAppUser', 'GET', NULL, 0, '{\"aera\":\"855\",\"number\":\"123123123\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-28 12:23:45', NULL);
INSERT INTO `sys_operation_log` VALUES (133, '1310881735185006594', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"81612642\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-29 17:58:55', NULL);
INSERT INTO `sys_operation_log` VALUES (134, '1310882690714611713', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"81612643\"}', NULL, 5, 0, NULL, NULL, 'org.springframework.data.redis.serializer.SerializationException', 'Could not read JSON: Invalid UTF-32 character 0x22353636 (above 0x0010ffff) at char #30, byte #123); nested exception is java.io.CharConversionException: Invalid UTF-32 character 0x22353636 (above 0x0010ffff) at char #30, byte #123)', 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-29 18:02:43', NULL);
INSERT INTO `sys_operation_log` VALUES (135, '1310883804474257409', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"816126437\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-29 18:07:09', NULL);
INSERT INTO `sys_operation_log` VALUES (136, '1311133850260238337', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"112233\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 10:40:44', NULL);
INSERT INTO `sys_operation_log` VALUES (137, '1311133861064765441', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"112233\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 10:40:47', NULL);
INSERT INTO `sys_operation_log` VALUES (138, '1311133866462834690', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"112233\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 10:40:48', NULL);
INSERT INTO `sys_operation_log` VALUES (139, '1311133912637927426', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"112233\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 10:40:59', NULL);
INSERT INTO `sys_operation_log` VALUES (140, '1311142177883041794', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/register', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'register', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"81611122\",\"smsCode\":\"\"},\"\"]', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 11:13:50', NULL);
INSERT INTO `sys_operation_log` VALUES (141, '1311148193878192130', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"112233\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 11:37:44', NULL);
INSERT INTO `sys_operation_log` VALUES (142, '1311151353510309889', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"2123\",\"number\":\"123\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 11:50:17', NULL);
INSERT INTO `sys_operation_log` VALUES (143, '1311151590845001730', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"2123\",\"number\":\"123\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 11:51:14', NULL);
INSERT INTO `sys_operation_log` VALUES (144, '1311152558240247810', NULL, NULL, '获取注册验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"86\",\"number\":\"15606952119\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 11:55:05', NULL);
INSERT INTO `sys_operation_log` VALUES (145, '1311152695410765825', NULL, NULL, '获取注册验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"86\",\"number\":\"15606952119\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 11:55:37', NULL);
INSERT INTO `sys_operation_log` VALUES (146, '1311152755150237697', NULL, NULL, '获取注册验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"86\",\"number\":\"15606952119\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 11:55:51', NULL);
INSERT INTO `sys_operation_log` VALUES (147, '1311153191575957506', NULL, NULL, '获取注册验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"86\",\"number\":\"15606952119\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 11:57:36', NULL);
INSERT INTO `sys_operation_log` VALUES (148, '1311153401345683458', NULL, NULL, '获取注册验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"86\",\"number\":\"15606952119\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 11:58:26', NULL);
INSERT INTO `sys_operation_log` VALUES (149, '1311153446300233729', NULL, NULL, '获取注册验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"86\",\"number\":\"15606952119\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 11:58:36', NULL);
INSERT INTO `sys_operation_log` VALUES (150, '1311153586721337346', NULL, NULL, '获取注册验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"86\",\"number\":\"15606952119\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 11:59:10', NULL);
INSERT INTO `sys_operation_log` VALUES (151, '1311153943350423554', NULL, NULL, '获取注册验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"86\",\"number\":\"15606952119\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 12:00:35', NULL);
INSERT INTO `sys_operation_log` VALUES (152, '1311161409182158849', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"112233\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 12:30:15', NULL);
INSERT INTO `sys_operation_log` VALUES (153, '1311161473707331585', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/register', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'register', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"1122\"},\"\"]', NULL, NULL, NULL, 500, 'FAIL', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:30:30', NULL);
INSERT INTO `sys_operation_log` VALUES (154, '1311161509648322562', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/register', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'register', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 6001, 'password or phone number error', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:30:39', NULL);
INSERT INTO `sys_operation_log` VALUES (155, '1311161615265091585', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/register', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'register', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 6001, 'password or phone number error', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:31:04', NULL);
INSERT INTO `sys_operation_log` VALUES (156, '1311162030983557122', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/register', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'register', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 500, 'FAIL', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:32:43', NULL);
INSERT INTO `sys_operation_log` VALUES (157, '1311162060754726913', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/register', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'register', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 500, 'FAIL', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:32:50', NULL);
INSERT INTO `sys_operation_log` VALUES (158, '1311162082065985537', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"112233\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 12:32:55', NULL);
INSERT INTO `sys_operation_log` VALUES (159, '1311162112713764865', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/register', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'register', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:33:03', NULL);
INSERT INTO `sys_operation_log` VALUES (160, '1311162968318226433', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/register', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'register', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 500, 'FAIL', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:36:26', NULL);
INSERT INTO `sys_operation_log` VALUES (161, '1311162983803596801', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/register', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'register', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 500, 'FAIL', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:36:30', NULL);
INSERT INTO `sys_operation_log` VALUES (162, '1311164367328280577', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"081611122\",\"smsCode\":\"\"},\"\"]', NULL, NULL, NULL, 500, 'FAIL', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:42:00', NULL);
INSERT INTO `sys_operation_log` VALUES (163, '1311164382700404738', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"081611122\",\"smsCode\":\"123123123\"},\"\"]', NULL, NULL, NULL, 500, 'FAIL', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:42:04', NULL);
INSERT INTO `sys_operation_log` VALUES (164, '1311164438132326402', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"112233\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 12:42:17', NULL);
INSERT INTO `sys_operation_log` VALUES (165, '1311164468285177857', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"081611122\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 500, 'FAIL', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:42:24', NULL);
INSERT INTO `sys_operation_log` VALUES (166, '1311164487188905985', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"081611122\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 500, 'FAIL', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:42:29', NULL);
INSERT INTO `sys_operation_log` VALUES (167, '1311164502703636481', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"081611122\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 12:42:32', NULL);
INSERT INTO `sys_operation_log` VALUES (168, '1311164515072638977', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"081611122\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:42:36', NULL);
INSERT INTO `sys_operation_log` VALUES (169, '1311166367373762561', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"081611122\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 12:49:57', NULL);
INSERT INTO `sys_operation_log` VALUES (170, '1311166374336307201', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"081611122\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 12:49:58', NULL);
INSERT INTO `sys_operation_log` VALUES (171, '1311166384113229826', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"081611122\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 12:50:01', NULL);
INSERT INTO `sys_operation_log` VALUES (172, '1311197614963691521', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"081611122\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 14:54:07', NULL);
INSERT INTO `sys_operation_log` VALUES (173, '1311197631808016386', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"081611122\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 14:54:11', NULL);
INSERT INTO `sys_operation_log` VALUES (174, '1311198281497350145', NULL, NULL, '获取注册验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/register', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"081611122\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 14:56:46', NULL);
INSERT INTO `sys_operation_log` VALUES (175, '1311198314946924546', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"081611122\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 14:56:54', NULL);
INSERT INTO `sys_operation_log` VALUES (176, '1311198490910560258', NULL, NULL, 'needRoleAll', '127.0.0.1', '本机地址', NULL, '/api/app/needRoleAll', NULL, 'com.jumeirah.api.app.controller.AppHelloWorldController', 'needRoleAll', 'GET', NULL, 0, NULL, 'fa4599bdf150b3fb8fb663ac0c42a881', 0, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 14:57:36', NULL);
INSERT INTO `sys_operation_log` VALUES (177, '1311202941079678978', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"123\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:15:17', NULL);
INSERT INTO `sys_operation_log` VALUES (178, '1311203006464684034', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"123\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 15:15:33', NULL);
INSERT INTO `sys_operation_log` VALUES (179, '1311204789278789633', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"area\":\"855\",\"number\":\"112233\"}', NULL, 5, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:22:38', NULL);
INSERT INTO `sys_operation_log` VALUES (180, '1311204912385806337', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 15:23:07', NULL);
INSERT INTO `sys_operation_log` VALUES (181, '1311204994661273602', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"\",\"name\":\"\",\"companyName\":\"\",\"wechat\":\"\",\"dateOfBirth\":\"\",\"nickname\":\"\",\"gender\":0,\"head\":\"\"}', '4f6ea139a0fe845e62244e253ff69d00', NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 15:23:27', NULL);
INSERT INTO `sys_operation_log` VALUES (182, '1311205250518011905', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"姓\",\"name\":\"名字\",\"companyName\":\"2\",\"wechat\":\"\",\"dateOfBirth\":\"\",\"nickname\":\"\",\"gender\":2,\"head\":\"\"}', '4f6ea139a0fe845e62244e253ff69d00', NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 15:24:28', NULL);
INSERT INTO `sys_operation_log` VALUES (183, '1311205451437756418', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"姓1\",\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"\",\"gender\":1,\"head\":\"\"}', '4f6ea139a0fe845e62244e253ff69d00', NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 15:25:16', NULL);
INSERT INTO `sys_operation_log` VALUES (184, '1311205493368213506', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"姓2221\",\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"\",\"gender\":1,\"head\":\"\"}', '4f6ea139a0fe845e62244e253ff69d00', NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 15:25:26', NULL);
INSERT INTO `sys_operation_log` VALUES (185, '1311206028951482370', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"姓2221\",\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"\",\"gender\":1,\"head\":\"\"}', '4f6ea139a0fe845e62244e253ff69d00', NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 15:27:34', NULL);
INSERT INTO `sys_operation_log` VALUES (186, '1311206110786547713', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"姓2221\",\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"搭建了哈达哈\",\"gender\":1,\"head\":\"\"}', '4f6ea139a0fe845e62244e253ff69d00', NULL, NULL, 200, 'SUCCESS', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 15:27:53', NULL);
INSERT INTO `sys_operation_log` VALUES (187, '1311211382913409026', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 500, '操作失败', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 15:48:50', NULL);
INSERT INTO `sys_operation_log` VALUES (188, '1311213060685340673', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:29', NULL);
INSERT INTO `sys_operation_log` VALUES (189, '1311213069392715777', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:32', NULL);
INSERT INTO `sys_operation_log` VALUES (190, '1311213077680660482', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:33', NULL);
INSERT INTO `sys_operation_log` VALUES (191, '1311213082856431617', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:35', NULL);
INSERT INTO `sys_operation_log` VALUES (192, '1311213087570829314', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:36', NULL);
INSERT INTO `sys_operation_log` VALUES (193, '1311213091807076354', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:37', NULL);
INSERT INTO `sys_operation_log` VALUES (194, '1311213098685734913', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:38', NULL);
INSERT INTO `sys_operation_log` VALUES (195, '1311213105409204226', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:40', NULL);
INSERT INTO `sys_operation_log` VALUES (196, '1311213110173933569', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:41', NULL);
INSERT INTO `sys_operation_log` VALUES (197, '1311213114871554050', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:42', NULL);
INSERT INTO `sys_operation_log` VALUES (198, '1311213118705147905', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:43', NULL);
INSERT INTO `sys_operation_log` VALUES (199, '1311213123163693058', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:44', NULL);
INSERT INTO `sys_operation_log` VALUES (200, '1311213135859851265', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 15:55:47', NULL);
INSERT INTO `sys_operation_log` VALUES (201, '1311219318595280898', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"112233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 500, '操作失败', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:20:22', NULL);
INSERT INTO `sys_operation_log` VALUES (202, '1311219342045634561', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"423423\",\"phoneArea\":\"234234234\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 16:20:27', NULL);
INSERT INTO `sys_operation_log` VALUES (203, '1311219370042613762', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"855\",\"phoneArea\":\"123\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 16:20:34', NULL);
INSERT INTO `sys_operation_log` VALUES (204, '1311219416834269186', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"123\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 500, '操作失败', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:20:45', NULL);
INSERT INTO `sys_operation_log` VALUES (205, '1311219442625044482', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"123\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 500, '操作失败', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:20:51', NULL);
INSERT INTO `sys_operation_log` VALUES (206, '1311219462078226433', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"855\",\"phoneArea\":\"123\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 16:20:56', NULL);
INSERT INTO `sys_operation_log` VALUES (207, '1311219478356320258', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"123\",\"phoneArea\":\"855\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 16:20:59', NULL);
INSERT INTO `sys_operation_log` VALUES (208, '1311219491274776578', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"123\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:21:03', NULL);
INSERT INTO `sys_operation_log` VALUES (209, '1311219623009476610', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"\",\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"搭建了哈达哈\",\"gender\":1,\"head\":\"\"}', '990532ff408958ebff170cfeeb89efc3', NULL, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:21:35', NULL);
INSERT INTO `sys_operation_log` VALUES (210, '1311219662888919041', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"23123\",\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"搭建了哈达哈\",\"gender\":1,\"head\":\"\"}', '990532ff408958ebff170cfeeb89efc3', NULL, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:21:44', NULL);
INSERT INTO `sys_operation_log` VALUES (211, '1311219674913988610', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"23123\",\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"搭建了哈达哈\",\"gender\":1,\"head\":\"\"}', '990532ff408958ebff170cfeeb89efc3', NULL, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:21:47', NULL);
INSERT INTO `sys_operation_log` VALUES (212, '1311219704190230530', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"\",\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"搭建了哈达哈\",\"gender\":1,\"head\":\"\"}', '990532ff408958ebff170cfeeb89efc3', NULL, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:21:54', NULL);
INSERT INTO `sys_operation_log` VALUES (213, '1311219760104497153', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"surname\":\"士大夫\",\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"搭建了哈达哈\",\"gender\":1,\"head\":\"\"}', '990532ff408958ebff170cfeeb89efc3', NULL, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:22:07', NULL);
INSERT INTO `sys_operation_log` VALUES (214, '1311219797052121089', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"搭建了哈达哈\",\"gender\":1,\"head\":\"\"}', '990532ff408958ebff170cfeeb89efc3', NULL, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:22:16', NULL);
INSERT INTO `sys_operation_log` VALUES (215, '1311220078741577729', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json', 1, '{\"name\":\"名字2\",\"companyName\":\"2\",\"wechat\":\"aefawx\",\"dateOfBirth\":\"123-12-2\",\"nickname\":\"搭建了哈达哈\",\"gender\":1,\"head\":\"\"}', '990532ff408958ebff170cfeeb89efc3', NULL, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:23:23', NULL);
INSERT INTO `sys_operation_log` VALUES (216, '1311221704441200642', NULL, NULL, '获取注册或登陆的验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"15606952119\",\"phoneArea\":\"86\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 16:29:51', NULL);
INSERT INTO `sys_operation_log` VALUES (217, '1311221733084102657', NULL, NULL, NULL, '192.168.2.2', NULL, NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json; charset=utf-8', 1, '[{\"phoneArea\":\"86\",\"phone\":\"15606952119\",\"smsCode\":\"666666\"},null]', NULL, NULL, NULL, 200, '成功', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, NULL, '2020-09-30 16:29:58', NULL);
INSERT INTO `sys_operation_log` VALUES (218, '1311221739337809921', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"123\",\"phoneArea\":\"855\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 16:29:59', NULL);
INSERT INTO `sys_operation_log` VALUES (219, '1311221750645653505', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"123\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:30:02', NULL);
INSERT INTO `sys_operation_log` VALUES (220, '1311222773556707330', NULL, NULL, '获取注册或登陆的验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"15606952119\",\"phoneArea\":\"86\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 16:34:05', NULL);
INSERT INTO `sys_operation_log` VALUES (221, '1311222830959951874', NULL, NULL, NULL, '192.168.2.2', NULL, NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json; charset=utf-8', 1, '[{\"phoneArea\":\"86\",\"phone\":\"15606952119\",\"smsCode\":\"666666\"},null]', NULL, NULL, NULL, 200, '成功', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, NULL, '2020-09-30 16:34:19', NULL);
INSERT INTO `sys_operation_log` VALUES (222, '1311222921569501185', NULL, NULL, '获取注册或登陆的验证码', '127.0.0.1', '本机地址', NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"1233\",\"phoneArea\":\"855\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, '', '2020-09-30 16:34:40', NULL);
INSERT INTO `sys_operation_log` VALUES (223, '1311222959259516929', NULL, NULL, NULL, '127.0.0.1', '本机地址', NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json', 1, '[{\"phoneArea\":\"855\",\"phone\":\"1233\",\"smsCode\":\"666666\"},\"\"]', NULL, NULL, NULL, 200, '成功', NULL, NULL, 'Chrome', '85.0.4183.121', 'Webkit', '537.36', 'OSX', 'Mac', 0, NULL, NULL, NULL, '2020-09-30 16:34:50', NULL);
INSERT INTO `sys_operation_log` VALUES (224, '1311223029795127298', NULL, NULL, '获取注册或登陆的验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"966791823\",\"phoneArea\":\"86\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 16:35:06', NULL);
INSERT INTO `sys_operation_log` VALUES (225, '1311223052620529666', NULL, NULL, NULL, '192.168.2.2', NULL, NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json; charset=utf-8', 1, '[{\"phoneArea\":\"86\",\"phone\":\"966791823\",\"smsCode\":\"666666\"},null]', NULL, NULL, NULL, 200, '成功', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, NULL, '2020-09-30 16:35:13', NULL);
INSERT INTO `sys_operation_log` VALUES (226, '1311235350206611457', NULL, NULL, '获取注册或登陆的验证码', '192.168.2.2', NULL, NULL, '/api/app/sms/registerOrLoginCode', NULL, 'com.jumeirah.api.app.controller.AppSmsController', 'register', 'GET', NULL, 0, '{\"phone\":\"912312\",\"phoneArea\":\"86\"}', NULL, 5, NULL, 200, '成功', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, '', '2020-09-30 17:24:04', NULL);
INSERT INTO `sys_operation_log` VALUES (227, '1311235366392430593', NULL, NULL, NULL, '192.168.2.2', NULL, NULL, '/api/app/user/registerOrLogin', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'registerOrLogin', 'POST', 'application/json; charset=utf-8', 1, '[{\"phoneArea\":\"86\",\"phone\":\"912312\",\"smsCode\":\"666666\"},null]', NULL, NULL, NULL, 200, '成功', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, NULL, '2020-09-30 17:24:08', NULL);
INSERT INTO `sys_operation_log` VALUES (228, '1311235413670625282', NULL, NULL, NULL, '192.168.2.2', NULL, NULL, '/api/app/user/updateAppUserInfo', 'api-app', 'com.jumeirah.api.app.controller.AppUserController', 'updateAppUserInfo', 'POST', 'application/json; charset=utf-8', 1, '{\"surname\":\"123\",\"name\":\"123\",\"companyName\":\"3123\",\"wechat\":\"123\",\"dateOfBirth\":\"1995-05-20\",\"gender\":1}', 'b4289edd5fadca35f83b40fcdcc6d68c', NULL, NULL, 200, '成功', NULL, NULL, 'Unknown', NULL, 'Unknown', NULL, 'Unknown', 'Unknown', 0, NULL, NULL, NULL, '2020-09-30 17:24:19', NULL);
COMMIT;

-- ----------------------------
-- Table structure for sys_permission
-- ----------------------------
DROP TABLE IF EXISTS `sys_permission`;
CREATE TABLE `sys_permission` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '权限名称',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父id',
  `url` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '路径',
  `code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '唯一编码',
  `icon` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图标',
  `type` int(11) NOT NULL COMMENT '类型，1：菜单，2：按钮',
  `level` int(11) NOT NULL COMMENT '层级，1：第一级，2：第二级，N：第N级',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT '状态，0：禁用，1：启用',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT '版本',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `sys_permission_code_uindex` (`code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5003 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统权限';

-- ----------------------------
-- Records of sys_permission
-- ----------------------------
BEGIN;
INSERT INTO `sys_permission` VALUES (1, '系统管理', NULL, NULL, 'system:management', 'el-icon-s-unfold', 1, 1, 1, 0, '1权限备注', 0, '2019-10-26 11:12:40', NULL);
INSERT INTO `sys_permission` VALUES (100, '用户管理', 1, NULL, 'sys:user:management', 'el-icon-s-unfold', 1, 2, 1, 0, '100权限备注', 0, '2019-10-26 11:15:48', NULL);
INSERT INTO `sys_permission` VALUES (200, '角色管理', 1, NULL, 'sys:role:management', 'el-icon-s-unfold', 1, 2, 1, 0, '200权限备注', 0, '2019-10-26 11:15:48', NULL);
INSERT INTO `sys_permission` VALUES (300, '权限管理', 1, NULL, 'sys:permission:management', 'el-icon-s-unfold', 1, 2, 1, 0, '300权限备注', 0, '2019-10-26 11:15:48', NULL);
INSERT INTO `sys_permission` VALUES (400, '部门管理', 1, NULL, 'sys:department:management', 'el-icon-s-unfold', 1, 2, 1, 0, '400权限备注', 0, '2019-10-26 11:15:48', NULL);
INSERT INTO `sys_permission` VALUES (500, '日志管理', 1, NULL, 'sys:log:manager', 'el-icon-s-custom', 1, 2, 1, 0, '500权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (1000, '用户新增', 100, NULL, 'sys:user:add', 'el-icon-s-custom', 2, 3, 1, 0, '1000权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (1001, '用户修改', 100, NULL, 'sys:user:update', 'el-icon-s-custom', 2, 3, 1, 0, '1001权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (1002, '用户删除', 100, NULL, 'sys:user:delete', 'el-icon-s-custom', 2, 3, 1, 0, '1002权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (1003, '用户详情', 100, NULL, 'sys:user:info', 'el-icon-s-custom', 2, 3, 1, 0, '1003权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (1004, '用户分页列表', 100, NULL, 'sys:user:page', 'el-icon-s-custom', 2, 3, 1, 0, '1004权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (1005, '用户修改密码', 100, NULL, 'sys:user:update:password', 'el-icon-s-custom', 2, 3, 1, 0, '1005权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (1006, '用户修改头像', 100, NULL, 'sys:user:update:head', 'el-icon-s-custom', 2, 3, 1, 0, '1006权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (1007, '用户重置密码', 100, NULL, 'sys:user:reset:password', 'el-icon-s-custom', 2, 3, 1, 0, '1007权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (2000, '角色新增', 200, NULL, 'sys:role:add', 'el-icon-s-custom', 2, 3, 1, 0, '2000权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (2001, '角色修改', 200, NULL, 'sys:role:update', 'el-icon-s-custom', 2, 3, 1, 0, '2001权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (2002, '角色删除', 200, NULL, 'sys:role:delete', 'el-icon-s-custom', 2, 3, 1, 0, '2002权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (2003, '角色详情', 200, NULL, 'sys:role:info', 'el-icon-s-custom', 2, 3, 1, 0, '2003权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (2004, '角色分页列表', 200, NULL, 'sys:role:page', 'el-icon-s-custom', 2, 3, 1, 0, '2004权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (2005, '角色列表', 200, NULL, 'sys:role:list', 'el-icon-s-custom', 2, 3, 1, 0, '2005权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (2006, '角色权限ID列表', 200, NULL, 'sys:permission:three-ids-by-role-id', 'el-icon-s-custom', 2, 3, 1, 0, '2006权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3000, '权限新增', 300, NULL, 'sys:permission:add', 'el-icon-s-custom', 2, 3, 1, 0, '3000权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3001, '权限修改', 300, NULL, 'sys:permission:update', 'el-icon-s-custom', 2, 3, 1, 0, '3001权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3002, '权限删除', 300, NULL, 'sys:permission:delete', 'el-icon-s-custom', 2, 3, 1, 0, '3002权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3003, '权限详情', 300, NULL, 'sys:permission:info', 'el-icon-s-custom', 2, 3, 1, 0, '3003权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3004, '权限分页列表', 300, NULL, 'sys:permission:page', 'el-icon-s-custom', 2, 3, 1, 0, '3004权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3005, '权限所有列表', 300, NULL, 'sys:permission:all:menu:list', 'el-icon-s-custom', 2, 3, 1, 0, '3005权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3006, '权限所有树形列表', 300, NULL, 'sys:permission:all:menu:tree', 'el-icon-s-custom', 2, 3, 1, 0, '3006权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3007, '权限用户列表', 300, NULL, 'sys:permission:menu:list', 'el-icon-s-custom', 2, 3, 1, 0, '3007权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3008, '权限用户树形列表', 300, NULL, 'sys:permission:menu:tree', 'el-icon-s-custom', 2, 3, 1, 0, '3008权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3009, '权限用户代码列表', 300, NULL, 'sys:permission:codes', 'el-icon-s-custom', 2, 3, 1, 0, '3009权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3010, '导航菜单', 300, NULL, 'sys:permission:nav-menu', 'el-icon-s-custom', 2, 3, 1, 0, '3010权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (3011, '角色权限修改', 300, NULL, 'sys:role-permission:update', 'el-icon-s-custom', 2, 3, 1, 0, '3011权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (4000, '部门新增', 400, NULL, 'sys:department:add', 'el-icon-s-custom', 2, 3, 1, 0, '4000权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (4001, '部门修改', 400, NULL, 'sys:department:update', 'el-icon-s-custom', 2, 3, 1, 0, '4001权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (4002, '部门删除', 400, NULL, 'sys:department:delete', 'el-icon-s-custom', 2, 3, 1, 0, '4002权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (4003, '部门详情', 400, NULL, 'sys:department:info', 'el-icon-s-custom', 2, 3, 1, 0, '4003权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (4004, '部门分页列表', 400, NULL, 'sys:department:page', 'el-icon-s-custom', 2, 3, 1, 0, '4004权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (4005, '部门列表', 400, NULL, 'sys:department:list', 'el-icon-s-custom', 2, 3, 1, 0, '4005权限备注', 1, '2019-10-26 11:18:40', '2020-03-09 00:50:13');
INSERT INTO `sys_permission` VALUES (4006, '部门树形列表', 400, NULL, 'sys:department:all:tree', 'el-icon-s-custom', 2, 3, 1, 0, '4006权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (5001, '操作日志列表', 500, NULL, 'sys:operation:log:page', 'el-icon-s-custom', 2, 3, 1, 0, '5001权限备注', 0, '2019-10-26 11:18:40', NULL);
INSERT INTO `sys_permission` VALUES (5002, '登录日志列表', 500, NULL, 'sys:login:log:page', 'el-icon-s-custom', 2, 3, 1, 0, '5002权限备注', 0, '2019-10-26 11:18:40', NULL);
COMMIT;

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '角色名称',
  `code` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '角色唯一编码',
  `type` int(11) DEFAULT NULL COMMENT '角色类型',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT '角色状态，0：禁用，1：启用',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT '版本',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `sys_role_name_uindex` (`name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统角色';

-- ----------------------------
-- Records of sys_role
-- ----------------------------
BEGIN;
INSERT INTO `sys_role` VALUES (1, '管理员', 'admin', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (2, 'test', 'test', NULL, 1, '测试人员拥有部分权限', 0, '2019-10-25 09:48:02', NULL);
INSERT INTO `sys_role` VALUES (3, '管理员1', 'admin1', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (4, '管理员2', 'admin2', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (5, '管理员3', 'admin3', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (6, '管理员4', 'admin4', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (7, '管理员5', 'admin5', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (8, '管理员6', 'admin6', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (9, '管理员7', 'admin7', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (10, '管理员8', 'admin8', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (11, '管理员9', 'admin9', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (12, '管理员10', 'admin10', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (13, '管理员11', 'admin11', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (14, '管理员12', 'admin12', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (15, '管理员13', 'admin13', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (16, '管理员14', 'admin14', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (17, '管理员15', 'admin15', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (18, '管理员16', 'admin16', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (19, '管理员17', 'admin17', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (20, '管理员18', 'admin18', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (21, '管理员19', 'admin19', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (22, '管理员20', 'admin20', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
INSERT INTO `sys_role` VALUES (23, '管理员21', 'admin21', NULL, 1, '管理员拥有所有权限', 0, '2019-10-25 09:47:21', NULL);
COMMIT;

-- ----------------------------
-- Table structure for sys_role_permission
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_permission`;
CREATE TABLE `sys_role_permission` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `role_id` bigint(20) NOT NULL COMMENT '角色id',
  `permission_id` bigint(20) NOT NULL COMMENT '权限id',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT '状态，0：禁用，1：启用',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT '版本',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `permission_id` (`permission_id`) USING BTREE,
  KEY `role_id` (`role_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=345 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='角色权限关系';

-- ----------------------------
-- Records of sys_role_permission
-- ----------------------------
BEGIN;
INSERT INTO `sys_role_permission` VALUES (303, 1, 3008, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (304, 1, 1, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (305, 1, 3009, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (306, 1, 3010, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (307, 1, 3011, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (308, 1, 200, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (309, 1, 5001, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (310, 1, 5002, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (311, 1, 2000, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (312, 1, 400, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (313, 1, 2001, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (314, 1, 2002, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (315, 1, 2003, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (316, 1, 2004, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (317, 1, 2005, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (318, 1, 2006, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (319, 1, 4000, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (320, 1, 4001, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (321, 1, 4002, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (322, 1, 4003, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (323, 1, 100, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (324, 1, 4004, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (325, 1, 4005, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (326, 1, 4006, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (327, 1, 1000, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (328, 1, 1001, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (329, 1, 1002, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (330, 1, 1003, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (331, 1, 1004, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (332, 1, 300, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (333, 1, 1005, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (334, 1, 1006, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (335, 1, 1007, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (336, 1, 500, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (337, 1, 3000, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (338, 1, 3001, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (339, 1, 3002, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (340, 1, 3003, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (341, 1, 3004, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (342, 1, 3005, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (343, 1, 3006, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
INSERT INTO `sys_role_permission` VALUES (344, 1, 3007, 1, NULL, 0, '2020-04-01 00:14:36', NULL);
COMMIT;

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `username` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '用户名',
  `nickname` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '昵称',
  `password` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '密码',
  `salt` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '盐值',
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '手机号码',
  `gender` int(11) NOT NULL DEFAULT '1' COMMENT '性别，0：女，1：男，默认1',
  `head` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '头像',
  `remark` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '备注',
  `state` int(11) NOT NULL DEFAULT '1' COMMENT '状态，0：禁用，1：启用，2：锁定',
  `department_id` bigint(20) NOT NULL COMMENT '部门id',
  `role_id` bigint(20) NOT NULL COMMENT '角色id',
  `deleted` int(11) NOT NULL DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
  `version` int(11) NOT NULL DEFAULT '0' COMMENT '版本',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `sys_user_username_uindex` (`username`) USING BTREE,
  KEY `department_id` (`department_id`) USING BTREE,
  KEY `role_id` (`role_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='系统用户';

-- ----------------------------
-- Records of sys_user
-- ----------------------------
BEGIN;
INSERT INTO `sys_user` VALUES (1, 'admin', '管理员', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889900', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2020-02-26 00:00:00', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (2, 'test', '测试人员1', '34783fb724b259beb71a1279f7cd93bdcfd92a273d566f926419a37825c500df', '087c2e9857f35f1e243367f3b89b81c1', '15888889901', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Tester Account', 1, 1, 2, 0, 1, '2020-02-26 00:00:01', '2020-02-15 19:31:50');
INSERT INTO `sys_user` VALUES (3, 'admin1', '管理员1', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889902', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2020-02-26 00:09:09', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (4, 'admin2', '管理员2', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889903', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2020-02-26 16:10:06', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (5, 'admin3', '管理员3', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889904', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2020-02-26 16:10:06', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (6, 'admin4', '管理员4', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889905', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2020-02-26 16:10:06', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (7, 'admin5', '管理员5', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889906', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2020-02-26 23:59:59', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (8, 'admin6', '管理员6', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2020-02-26 23:59:59', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (9, 'admin7', '管理员7', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2020-02-20 23:59:59', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (10, 'admin8', '管理员8', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2020-01-30 22:56:55', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (11, 'admin9', '管理员9', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2019-12-30 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (12, 'admin10', '管理员10', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (13, 'admin11', '管理员11', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 1, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (14, 'admin12', '管理员12', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 2, 1, 1, 0, 2, '2019-08-26 00:52:01', '2020-02-27 14:05:40');
INSERT INTO `sys_user` VALUES (15, 'admin13', '管理员13uuu', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 2, 1, 1, 0, 3, '2019-08-26 00:52:01', '2020-02-27 14:05:18');
INSERT INTO `sys_user` VALUES (16, 'admin14', '管理员14', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 0, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (17, 'admin15', '管理员15', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 0, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (18, 'admin16', '管理员16', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 0, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (19, 'admin17', '管理员17', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 2, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (20, 'admin18', '管理员18', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 2, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (21, 'admin19', '管理员19', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 2, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (22, 'admin20', '管理员20', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 2, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (23, 'admin21', '管理员21', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 0, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (24, 'admin22', '管理员22', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 0, 1, 1, 0, 1, '2019-08-26 00:52:01', '2019-10-27 23:32:29');
INSERT INTO `sys_user` VALUES (25, 'admin23', '管理员23', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '666', '15888889999', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'Administrator Account', 2, 1, 1, 0, 3, '2019-08-26 00:52:01', '2020-02-27 14:42:28');
INSERT INTO `sys_user` VALUES (100, 'dddd', 'ddddd', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', 'aa98a65fa53d198f38d8e3a63f3f5a65', 'ddddddddddd', 1, 'http://localhost:8888/api/resource/201908201013068.png', 'dddddddd', 1, 1, 1, 0, 1, '2020-02-26 14:06:53', '2020-02-27 14:06:52');
INSERT INTO `sys_user` VALUES (101, 'adminx', '111111', '11a254dab80d52bc4a347e030e54d861a9d2cdb2af2185a9ca4a7318e830d04d', '1faf81180b4a4a78c48d7c31479a0622', '11111111111', 1, 'http://localhost:8888/api/resource/201908201013068.png', '1111111111', 1, 1, 1, 1, 6, '2020-02-26 14:19:57', '2020-03-02 17:33:48');
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
