package com.wecloud.utils;

import io.geekidea.springbootplus.framework.common.exception.BusinessException;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 * @Author wenzhida
 * @Date 2022/2/21 22:26
 * @Description 加解密工具类
 */
public class AesUtil {

    public static final String ALGORITHM = "AES";

    /**
     * AES/CBC/NOPaddin
     * AES 默认模式
     * 使用CBC模式, 在初始化Cipher对象时, 需要增加参数, 初始化向量IV : IvParameterSpec iv = new
     * IvParameterSpec(key.getBytes());
     * NOPadding: 使用NOPadding模式时, 原文长度必须是8byte的整数倍
     */
    public static final String TRANSFORMATION = "AES/CBC/NOPadding";

    public static final String key = "1234567812345678";

    /***
     * 加密
     * @param original 需要加密的参数（注意必须是16位）
     * @return
     * @throws Exception
     */
    public static String encrypt(String original) {
        try {
            // 获取Cipher
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            // 生成密钥
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), ALGORITHM);
            // 指定模式(加密)和密钥
            // 创建初始化向量
            IvParameterSpec iv = new IvParameterSpec(key.getBytes());
            cipher.init(Cipher.ENCRYPT_MODE, keySpec, iv);
            // cipher.init(Cipher.ENCRYPT_MODE, keySpec);
            // 加密
            byte[] bytes = cipher.doFinal(original.getBytes());
            return Base64Util.encryptBASE64(bytes);
        } catch (Exception e) {
            throw new BusinessException("加密出现错误");
        }
    }

    /**
     * 解密
     *
     * @param encrypted 需要解密的参数
     * @return
     * @throws Exception
     */
    public static String decrypt(String encrypted) {
        try {
            // 获取Cipher
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            // 生成密钥
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), ALGORITHM);
            // 指定模式(解密)和密钥
            // 创建初始化向量
            IvParameterSpec iv = new IvParameterSpec(key.getBytes());
            cipher.init(Cipher.DECRYPT_MODE, keySpec, iv);
            // cipher.init(Cipher.DECRYPT_MODE, keySpec);
            // 解密
            byte[] bytes = cipher.doFinal(Base64Util.decryBASE64(encrypted));

            return new String(bytes);
        } catch (Exception e) {
            throw new BusinessException("解密出现错误");
        }
    }


}
