package com.wecloud.im.user.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.protobuf.ServiceException;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.user.entity.User;
import com.wecloud.im.user.mapper.UserMapper;
import com.wecloud.im.user.param.ChangePhoneParam;
import com.wecloud.im.user.param.ResetPasswordParam;
import com.wecloud.im.user.param.UserLoginParam;
import com.wecloud.im.user.param.UserRegisterParam;
import com.wecloud.im.ws.utils.RedisUtils;
import com.wecloud.utils.AesUtil;
import com.wecloud.utils.SnowflakeUtil;
import io.geekidea.springbootplus.framework.common.exception.BusinessException;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * @Author wenzhida
 * @Date 2022/2/21 17:05
 * @Description 用户服务接口
 */
@Service
public class UserService extends BaseServiceImpl<UserMapper, User> {


    @Autowired
    private RedisUtils redisUtils;

    /**
     * 注册用户
     * @param param
     */
    public void registerUser(UserRegisterParam param) {
        User userExist = this.getOne(new QueryWrapper<User>().lambda()
                .eq(User::getPhone, param.getPhone()));
        if (userExist != null) {
            throw new BusinessException("已存在此电话号码用户");
        }
        User user = new User();
        user.setId(SnowflakeUtil.getId());
        user.setPhone(param.getPhone());
        user.setPassword(AesUtil.encrypt(param.getPassword()));
        user.setCreateTime(new Date());
        this.save(user);
    }

    /**
     * 用户登录
     * @param param
     */
    public void loginUser(UserLoginParam param) {
        User user = this.getOne(new QueryWrapper<User>().lambda()
                .eq(User::getPhone, param.getPhone()));
        if (!param.getPassword().equals(AesUtil.decrypt(user.getPassword()))) {
            throw new BusinessException("账户或密码错误");
        }
    }

    /**
     * 重置密码
     * @param param
     */
    public void resetPassword(ResetPasswordParam param) {
        User user = this.getOne(new QueryWrapper<User>().lambda()
                .eq(User::getPhone, param.getPhone()));
        if (user == null) {
            throw new BusinessException("查无此用户");
        }
        user.setPassword(AesUtil.encrypt(param.getPassword()));
        this.updateById(user);
    }

    /**
     * 更换手机号码
     * @param param
     */
    public void changePhone(ChangePhoneParam param) {
        User user = this.getOne(new QueryWrapper<User>().lambda()
                .eq(User::getPhone, param.getPhone()));
        if (user == null) {
            throw new BusinessException("查无此用户");
        }
        user.setPhone(param.getPhone());
        this.updateById(user);
    }

    /**
     * 校验短信验证码
     * @param verifyCode
     * @param redisKey
     */
    public void verifySMSVerifyCode(String verifyCode, String redisKey) {
        String verifyCodeInRedis = redisUtils.getKey(redisKey);
        if (verifyCodeInRedis == null || !verifyCodeInRedis.equals(verifyCode)) {
            throw new BusinessException("短信验证码不正确");
        }
        redisUtils.delKey(redisKey);
    }

}
