package com.wecloud.im.user.param;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author wenzhida
 * @Date 2022/2/21 18:15
 * @Description 用户登录入参
 */
@Data
public class UserLoginParam implements Serializable {

    private static final long serialVersionUID = 9182337935301787778L;

    /**
     * 电话号码
     */
    @NotNull(message = "电话号码不可为空")
    private String phone;

    /**
     * 密码
     */
    @NotNull(message = "密码不可为空")
    private String password;

}
