package com.wecloud.im.user.controller;

import com.wecloud.im.enums.VerifySceneEnum;
import com.wecloud.im.user.constant.RedisKeyPrefixConstant;
import com.wecloud.im.user.param.ChangePhoneParam;
import com.wecloud.im.user.param.ResetPasswordParam;
import com.wecloud.im.user.param.UserLoginParam;
import com.wecloud.im.user.param.UserRegisterParam;
import com.wecloud.im.user.service.UserService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author wenzhida
 * @Date 2022/2/21 17:05
 * @Description 用户控制器
 */
@Slf4j
@RestController
@RequestMapping("/user")
@Api(value = "用户相关API", tags = {"用户"})
public class UserController extends BaseController {

    @Autowired
    private UserService userService;

    @PostMapping("/register")
    @ApiOperation(value = "用户注册接口")
    public ApiResult<Boolean> register(@RequestBody @Validated UserRegisterParam param) {
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        String key = new StringBuilder(RedisKeyPrefixConstant.VERIFY_CODE_PREFIX).append(VerifySceneEnum.REGISTER.getCode()).append(param.getPhone()).toString();
        userService.verifySMSVerifyCode(param.getVerifyCode(), key);
        userService.registerUser(param);
        return ApiResult.ok();
    }

    @PostMapping("/login")
    @ApiOperation(value = "用户登录接口")
    public ApiResult<Boolean> login(@RequestBody @Validated UserLoginParam param) {
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        userService.loginUser(param);
        return ApiResult.ok();
    }

    @PostMapping("/resetPassword")
    @ApiOperation(value = "重置密码接口")
    public ApiResult<Boolean> resetPassword(@RequestBody @Validated ResetPasswordParam param) {
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        String key = new StringBuilder(RedisKeyPrefixConstant.VERIFY_CODE_PREFIX).append(VerifySceneEnum.RESET_PWD.getCode()).append(param.getPhone()).toString();
        userService.verifySMSVerifyCode(param.getVerifyCode(), key);
        userService.resetPassword(param);
        return ApiResult.ok();
    }

    @PostMapping("/changePhone")
    @ApiOperation(value = "更换手机号接口")
    public ApiResult<Boolean> changePhone(@RequestBody @Validated ChangePhoneParam param) {
        if (param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        String key = new StringBuilder(RedisKeyPrefixConstant.VERIFY_CODE_PREFIX).append(VerifySceneEnum.CHANGE_PHONE.getCode()).append(param.getPhone()).toString();
        userService.verifySMSVerifyCode(param.getVerifyCode(), key);
        userService.changePhone(param);
        return ApiResult.ok();
    }

}

