package com.sien.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sien.common.entity.VipPrice;
import com.sien.common.param.VipPricePageParam;
import com.sien.common.vo.app.VipPriceQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 会员价格表 Mapper 接口
 *
 * @author xxx
 * @since 2021-03-11
 */
@Repository
public interface VipPriceMapper extends BaseMapper<VipPrice> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    VipPriceQueryVo getVipPriceById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param vipPricePageParam
     * @return
     */
    IPage<VipPriceQueryVo> getVipPricePageList(@Param("page") Page page, @Param("param") VipPricePageParam vipPricePageParam);

}
