package com.wecloud.im.biz.module.message.service;

import com.wecloud.can.datasource.mybatisplus.pagination.Paging;
import com.wecloud.can.datasource.mybatisplus.service.BaseService;
import com.wecloud.im.biz.module.message.controller.param.ImApplicationPageParam;
import com.wecloud.im.biz.module.message.controller.param.ImApplicationQueryVo;
import com.wecloud.im.biz.module.message.entity.ImApplication;

/**
 * 第三方应用表 服务类
 *
 * @author wei
 * @since 2021-04-27
 */
public interface ImApplicationService extends BaseService<ImApplication> {


    /**
     * 根据id查询应用数据 redis缓存
     *
     * @param id
     * @return
     */
    ImApplication getCacheById(Long id);


    /**
     * 删除缓存
     *
     * @param id
     */
    void deleteCacheById(Long id);

    /**
     * 删除缓存
     *
     * @param appKey
     */
    void deleteCacheByAppKey(String appKey);


    /**
     * 根据appKey查询application
     *
     * @param appKey
     * @return
     */
    ImApplication getCacheAppByAppKey(String appKey);

    /**
     * 保存
     *
     * @param imApplication
     * @return
     * @throws Exception
     */
    boolean saveImApplication(ImApplication imApplication) throws Exception;

//    /**
//     * 修改
//     *
//     * @param imApplication
//     * @return
//     * @throws Exception
//     */
//    boolean updateImApplication(ImApplication imApplication) throws Exception;
//
//    /**
//     * 删除
//     *
//     * @param id
//     * @return
//     * @throws Exception
//     */
//    boolean deleteImApplication(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImApplicationQueryVo getImApplicationById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param imApplicationPageParam
     * @return
     * @throws Exception
     */
    Paging<ImApplicationQueryVo> getImApplicationPageList(ImApplicationPageParam imApplicationPageParam) throws Exception;

}
