package com.wecloud.im.thousandchat.cache;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.ws.cache.UserStateListener;
import com.wecloud.im.ws.utils.InitIp;
import com.wecloud.im.ws.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 千人群的缓存（本地缓存待实现）
 * @author lixiaozhong
 * @date 2022年01月4日 17:00:00
 */
@Service
@Slf4j
public class GroupCacheManager extends UserStateListener {

    /**
     * redis的群键 key
     */
    public static final String GROUP_KEY = "gp:";
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private ImConversationMembersService imConversationMembersService;

    @Override
    public void onLineEvent(Long clientId, Integer platform, String longChannelId) {
        List<Long> thousandGroupIds = imConversationMembersService.findThousandGroupsByClientId(clientId);
        for(Long thousandGroupId : thousandGroupIds) {
            redisUtils.hashset(GROUP_KEY + thousandGroupId, clientId + RedisUtils.SPLIT + platform, InitIp.lAN_IP,
                150, TimeUnit.DAYS);
        }

    }

    @Override
    public void offlineEvent(Long clientId, Integer platform, String longChannelId) {
        List<Long> thousandGroupIds = imConversationMembersService.findThousandGroupsByClientId(clientId);
        for(Long thousandGroupId : thousandGroupIds) {
            redisUtils.hashdel(GROUP_KEY + thousandGroupId, clientId + RedisUtils.SPLIT + platform);
        }
    }

    /**
     * 根据群ID 获取 万人群的 在线成员的key-val
     * @param conversionId
     * @return 在线成员的key-val，其中key是 client的主键id:platform, val是 ip
     */
    public Map<String, String> findOnlineClientsByThousandGroupId(Long conversionId) {
        return redisUtils.hashgetll(GROUP_KEY + conversionId);
    }


}
